/**
 * Hero Plugin - ปลั๊กอินสำหรับส่วนแสดงผลหลัก (Hero Section)
 */
(function(global) {
  'use strict';

  /**
   * คลาส HeroPlugin
   * ปลั๊กอินสำหรับส่วนแสดงผลหลัก (Hero Section)
   */
  class HeroPlugin {
    constructor(editor) {
      this.editor = editor;
      this.name = 'hero';
      this.title = 'Hero Section';
      this.icon = 'view_carousel';
      this.description = 'ส่วนแสดงผลหลัก';
    }

    /**
     * เริ่มต้นปลั๊กอิน
     */
    init() {
      if (this.editor.config.debug) {
        console.log('HeroPlugin เริ่มต้นแล้ว');
      }
    }

    /**
     * รับเทมเพลตของปลั๊กอิน
     */
    getTemplate() {
      return `
                <section class="editor-component hero" data-component="hero">
                    <div class="container">
                        <div class="hero-content">
                            <h1 data-editable="true">ยินดีต้อนรับสู่เว็บไซต์ของเรา</h1>
                            <p data-editable="true">นี่คือส่วนแสดงผลหลักของเว็บไซต์ สามารถแก้ไขข้อความได้ตามต้องการ</p>
                            <div class="hero-actions">
                                <button class="btn btn-primary" data-editable="true">เรียนรู้เพิ่มเติม</button>
                                <button class="btn btn-outline" data-editable="true">ดูตัวอย่าง</button>
                            </div>
                        </div>
                    </div>
                </section>
            `;
    }

    /**
     * รับ CSS ของปลั๊กอิน
     */
    getCSS() {
      return `
                .hero {
                    background-color: #f5f5f5;
                    padding: 80px 0;
                    text-align: center;
                    position: relative;
                    overflow: hidden;
                }

                .hero::before {
                    content: '';
                    position: absolute;
                    top: 0;
                    left: 0;
                    right: 0;
                    bottom: 0;
                    background-image: url('https://picsum.photos/seed/hero/1920/1080.jpg');
                    background-size: cover;
                    background-position: center;
                    opacity: 0.1;
                }

                .hero .container {
                    max-width: 1200px;
                    margin: 0 auto;
                    padding: 0 20px;
                }

                .hero-content {
                    max-width: 800px;
                    margin: 0 auto;
                }

                .hero h1 {
                    font-size: 48px;
                    margin-bottom: 20px;
                    color: #333;
                }

                .hero p {
                    font-size: 18px;
                    margin-bottom: 30px;
                    color: #666;
                    line-height: 1.6;
                }

                .hero-actions {
                    display: flex;
                    justify-content: center;
                    gap: 20px;
                }

                .btn {
                    display: inline-block;
                    padding: 12px 24px;
                    border-radius: 4px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                    text-decoration: none;
                    font-family: inherit;
                }

                .btn-primary {
                    background-color: #2196F3;
                    color: white;
                    border: none;
                }

                .btn-primary:hover {
                    background-color: #1976D2;
                }

                .btn-outline {
                    background-color: transparent;
                    border: 1px solid #2196F3;
                    color: #2196F3;
                }

                .btn-outline:hover {
                    background-color: #2196F3;
                    color: white;
                }

                @media (max-width: 768px) {
                    .hero {
                        padding: 60px 0;
                    }

                    .hero h1 {
                        font-size: 36px;
                    }

                    .hero p {
                        font-size: 16px;
                    }

                    .hero-actions {
                        flex-direction: column;
                        align-items: center;
                        gap: 15px;
                    }

                    .btn {
                        width: 200px;
                    }
                }
            `;
    }

    /**
     * รับการตั้งค่าของปลั๊กอิน
     */
    getSettings() {
      return {
        backgroundImage: {
          type: 'text',
          label: 'รูปภาพพื้นหลัง',
          default: 'https://picsum.photos/seed/hero/1920/1080.jpg'
        },
        backgroundOpacity: {
          type: 'range',
          label: 'ความทึบของพื้นหลัง',
          min: 0,
          max: 1,
          step: 0.1,
          default: 0.1
        },
        backgroundColor: {
          type: 'color',
          label: 'สีพื้นหลัง',
          default: '#f5f5f5'
        },
        titleColor: {
          type: 'color',
          label: 'สีหัวข้อ',
          default: '#333333'
        },
        textColor: {
          type: 'color',
          label: 'สีข้อความ',
          default: '#666666'
        },
        primaryButtonColor: {
          type: 'color',
          label: 'สีปุ่มหลัก',
          default: '#2196F3'
        },
        showSecondaryButton: {
          type: 'checkbox',
          label: 'แสดงปุ่มรอง',
          default: true
        }
      };
    }
  }

  // เปิดเผยคลาส HeroPlugin ทั่วโลก
  global.HeroPlugin = HeroPlugin;

})(typeof window !== 'undefined' ? window : this);