/**
 * Footer Plugin - ปลั๊กอินสำหรับส่วนท้ายของเว็บไซต์
 */
(function(global) {
  'use strict';

  /**
   * คลาส FooterPlugin
   * ปลั๊กอินสำหรับส่วนท้ายของเว็บไซต์
   */
  class FooterPlugin {
    constructor(editor) {
      this.editor = editor;
      this.name = 'footer';
      this.title = 'ส่วนท้าย';
      this.icon = 'footer';
      this.description = 'ส่วนท้ายของเว็บไซต์';
    }

    /**
     * เริ่มต้นปลั๊กอิน
     */
    init() {
      if (this.editor.config.debug) {
        console.log('FooterPlugin เริ่มต้นแล้ว');
      }
    }

    /**
     * รับเทมเพลตของปลั๊กอิน
     */
    getTemplate() {
      return `
                <footer class="editor-component footer" data-component="footer">
                    <div class="container">
                        <div class="footer-content">
                            <div class="footer-section">
                                <h3 data-editable="true">เกี่ยวกับเรา</h3>
                                <p data-editable="true">Website Template Editor เป็นเครื่องมือสำหรับสร้างและแก้ไขเว็บไซต์แบบอินไลน์</p>
                            </div>
                            <div class="footer-section">
                                <h3 data-editable="true">ลิงก์ด่วน</h3>
                                <ul>
                                    <li><a href="#" data-editable="true">หน้าแรก</a></li>
                                    <li><a href="#" data-editable="true">เกี่ยวกับ</a></li>
                                    <li><a href="#" data-editable="true">บริการ</a></li>
                                    <li><a href="#" data-editable="true">ติดต่อ</a></li>
                                </ul>
                            </div>
                            <div class="footer-section">
                                <h3 data-editable="true">ติดต่อเรา</h3>
                                <p data-editable="true">อีเมล: info@templateeditor.com</p>
                                <p data-editable="true">โทร: 02-123-4567</p>
                            </div>
                        </div>
                        <div class="footer-bottom">
                            <p data-editable="true">&copy; 2023 Website Template Editor. สงวนลิขสิทธิ์</p>
                        </div>
                    </div>
                </footer>
            `;
    }

    /**
     * รับ CSS ของปลั๊กอิน
     */
    getCSS() {
      return `
                .footer {
                    background-color: #333;
                    color: white;
                    padding: 40px 0 20px;
                }

                .footer .container {
                    max-width: 1200px;
                    margin: 0 auto;
                    padding: 0 20px;
                }

                .footer-content {
                    display: grid;
                    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
                    gap: 30px;
                    margin-bottom: 30px;
                }

                .footer-section h3 {
                    font-size: 20px;
                    margin-bottom: 20px;
                    color: white;
                }

                .footer-section ul {
                    list-style: none;
                    padding: 0;
                    margin: 0;
                }

                .footer-section li {
                    margin-bottom: 10px;
                }

                .footer-section a {
                    color: #ccc;
                    text-decoration: none;
                    transition: color 0.2s;
                }

                .footer-section a:hover {
                    color: white;
                }

                .footer-section p {
                    color: #ccc;
                    margin-bottom: 10px;
                }

                .footer-bottom {
                    text-align: center;
                    padding-top: 20px;
                    margin-top: 20px;
                    border-top: 1px solid #555;
                    color: #ccc;
                }

                @media (max-width: 768px) {
                    .footer-content {
                        grid-template-columns: 1fr;
                        gap: 20px;
                    }
                }
            `;
    }

    /**
     * รับการตั้งค่าของปลั๊กอิน
     */
    getSettings() {
      return {
        backgroundColor: {
          type: 'color',
          label: 'สีพื้นหลัง',
          default: '#333333'
        },
        textColor: {
          type: 'color',
          label: 'สีข้อความ',
          default: '#ffffff'
        },
        linkColor: {
          type: 'color',
          label: 'สีลิงก์',
          default: '#cccccc'
        },
        showSocialLinks: {
          type: 'checkbox',
          label: 'แสดงลิงก์โซเชียล',
          default: false
        },
        socialLinks: {
          type: 'object',
          label: 'ลิงก์โซเชียล',
          default: {
            facebook: '',
            twitter: '',
            instagram: '',
            linkedin: ''
          }
        }
      };
    }
  }

  // เปิดเผยคลาส FooterPlugin ทั่วโลก
  global.FooterPlugin = FooterPlugin;

})(typeof window !== 'undefined' ? window : this);