/**
 * Carousel Plugin - ปลั๊กอินสำหรับสไลด์โชว์รูปภาพ
 */
(function(global) {
  'use strict';

  /**
   * คลาส CarouselPlugin
   * ปลั๊กอินสำหรับสไลด์โชว์รูปภาพ
   */
  class CarouselPlugin {
    constructor(editor) {
      this.editor = editor;
      this.name = 'carousel';
      this.title = 'Carousel';
      this.icon = 'slideshow';
      this.description = 'สไลด์โชว์รูปภาพ';
    }

    /**
     * เริ่มต้นปลั๊กอิน
     */
    init() {
      if (this.editor.config.debug) {
        console.log('CarouselPlugin เริ่มต้นแล้ว');
      }
    }

    /**
     * รับเทมเพลตของปลั๊กอิน
     */
    getTemplate() {
      return `
                <section class="editor-component carousel" data-component="carousel">
                    <div class="container">
                        <div class="carousel-container">
                            <div class="carousel-slides">
                                <div class="carousel-slide active">
                                    <img src="https://picsum.photos/seed/slide1/800/400.jpg" alt="สไลด์ 1">
                                    <div class="carousel-caption">
                                        <h3 data-editable="true">สไลด์ที่ 1</h3>
                                        <p data-editable="true">คำอธิบายสไลด์ที่ 1</p>
                                    </div>
                                </div>
                                <div class="carousel-slide">
                                    <img src="https://picsum.photos/seed/slide2/800/400.jpg" alt="สไลด์ 2">
                                    <div class="carousel-caption">
                                        <h3 data-editable="true">สไลด์ที่ 2</h3>
                                        <p data-editable="true">คำอธิบายสไลด์ที่ 2</p>
                                    </div>
                                </div>
                                <div class="carousel-slide">
                                    <img src="https://picsum.photos/seed/slide3/800/400.jpg" alt="สไลด์ 3">
                                    <div class="carousel-caption">
                                        <h3 data-editable="true">สไลด์ที่ 3</h3>
                                        <p data-editable="true">คำอธิบายสไลด์ที่ 3</p>
                                    </div>
                                </div>
                            </div>
                            <div class="carousel-controls">
                                <button class="carousel-prev" aria-label="Previous slide">
                                    <i class="material-icons">chevron_left</i>
                                </button>
                                <button class="carousel-next" aria-label="Next slide">
                                    <i class="material-icons">chevron_right</i>
                                </button>
                            </div>
                            <div class="carousel-indicators">
                                <button class="carousel-indicator active" aria-label="Go to slide 1"></button>
                                <button class="carousel-indicator" aria-label="Go to slide 2"></button>
                                <button class="carousel-indicator" aria-label="Go to slide 3"></button>
                            </div>
                        </div>
                    </div>
                </section>
            `;
    }

    /**
     * รับ CSS ของปลั๊กอิน
     */
    getCSS() {
      return `
                .carousel {
                    padding: 40px 0;
                }

                .carousel .container {
                    max-width: 1200px;
                    margin: 0 auto;
                    padding: 0 20px;
                }

                .carousel-container {
                    position: relative;
                    overflow: hidden;
                    border-radius: 8px;
                    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
                }

                .carousel-slides {
                    display: flex;
                    transition: transform 0.5s ease;
                }

                .carousel-slide {
                    min-width: 100%;
                    position: relative;
                }

                .carousel-slide img {
                    width: 100%;
                    height: auto;
                    display: block;
                }

                .carousel-caption {
                    position: absolute;
                    bottom: 0;
                    left: 0;
                    right: 0;
                    background-color: rgba(0,0,0,0.7);
                    color: white;
                    padding: 20px;
                }

                .carousel-caption h3 {
                    margin: 0 0 10px 0;
                    font-size: 24px;
                }

                .carousel-caption p {
                    margin: 0;
                    font-size: 16px;
                }

                .carousel-controls {
                    position: absolute;
                    top: 50%;
                    transform: translateY(-50%);
                    width: 100%;
                    display: flex;
                    justify-content: space-between;
                    padding: 0 20px;
                    pointer-events: none;
                }

                .carousel-controls button {
                    background-color: rgba(255,255,255,0.7);
                    border: none;
                    width: 50px;
                    height: 50px;
                    border-radius: 50%;
                    display: flex;
                    align-items: center;
                    justify-content: center;
                    cursor: pointer;
                    pointer-events: all;
                    transition: background-color 0.2s;
                }

                .carousel-controls button:hover {
                    background-color: rgba(255,255,255,0.9);
                }

                .carousel-controls button i {
                    font-size: 24px;
                    color: #333;
                }

                .carousel-indicators {
                    position: absolute;
                    bottom: 20px;
                    left: 50%;
                    transform: translateX(-50%);
                    display: flex;
                    gap: 10px;
                }

                .carousel-indicator {
                    width: 12px;
                    height: 12px;
                    border-radius: 50%;
                    background-color: rgba(255,255,255,0.5);
                    border: none;
                    cursor: pointer;
                    transition: background-color 0.2s;
                }

                .carousel-indicator.active {
                    background-color: white;
                }

                @media (max-width: 768px) {
                    .carousel-caption h3 {
                        font-size: 20px;
                    }

                    .carousel-caption p {
                        font-size: 14px;
                    }

                    .carousel-controls button {
                        width: 40px;
                        height: 40px;
                    }

                    .carousel-controls button i {
                        font-size: 20px;
                    }
                }
            `;
    }

    /**
     * รับการตั้งค่าของปลั๊กอิน
     */
    getSettings() {
      return {
        autoplay: {
          type: 'checkbox',
          label: 'เล่นอัตโนมัติ',
          default: true
        },
        interval: {
          type: 'number',
          label: 'ระยะเวลา (วินาที)',
          min: 1000,
          max: 10000,
          default: 5000
        },
        showControls: {
          type: 'checkbox',
          label: 'แสดงปุ่มควบคุม',
          default: true
        },
        showIndicators: {
          type: 'checkbox',
          label: 'แสดงตัวบ่งชี้',
          default: true
        },
        animation: {
          type: 'select',
          label: 'แอนิเมชัน',
          options: [
            {value: 'slide', text: 'Slide'},
            {value: 'fade', text: 'Fade'},
            {value: 'scale', text: 'Scale'}
          ],
          default: 'slide'
        }
      };
    }
  }

  // เปิดเผยคลาส CarouselPlugin ทั่วโลก
  global.CarouselPlugin = CarouselPlugin;

})(typeof window !== 'undefined' ? window : this);