# Website Template Editor (ตัวแก้ไขเทมเพลตเว็บไซต์)

A lightweight browser-based WYSIWYG website template editor that lets you build and edit templates using components and plugins, with local persistence so edits survive page reloads.

ชื่อโปรเจ็ค: Website Template Editor (ตัวแก้ไขเทมเพลตเว็บไซต์)

## ความสามารถหลัก

- สร้าง/แก้ไขเทมเพลต HTML ด้วยอินเทอร์เฟซแบบ WYSIWYG
- โมดูลและปลั๊กอินที่ขยายได้ (header, footer, hero, carousel, card, grid ฯลฯ)
- Drag & drop component panel
- บันทึกเทมเพลตในเบราว์เซอร์ (localStorage) ผ่าน `StorageService` / `TemplateSaver`
- โหลดเทมเพลตจากไฟล์, URL หรือ localStorage ผ่าน `TemplateLoader`
- ประวัติเหตุการณ์ (EventBus) เพื่อให้โมดูลสื่อสารกัน

## เริ่มใช้งาน (Quick start)

1. เปิด `index.html` ในเบราว์เซอร์ (ไม่จำเป็นต้องมีเซิร์ฟเวอร์ สำหรับทดสอบพื้นฐาน)
2. กดปุ่ม "แก้ไข" เพื่อเข้าสู่โหมดแก้ไข แล้วแก้ไของค์ประกอบภายในหน้า
3. กดปุ่ม "บันทึก" เพื่อบันทึกการเปลี่ยนแปลงลงใน localStorage
4. โหลดหน้าใหม่ — เทมเพลตที่บันทึกไว้จะถูกกู้คืนอัตโนมัติ (restored)

หมายเหตุ: หากทดสอบจากไฟล์ระบบไฟล์ (file://) บราวเซอร์บางตัวอาจจำกัดฟีเจอร์ XHR/ไฟล์; ใช้เซิร์ฟเวอร์แบบง่ายถ้าจำเป็น (ตัวอย่าง: `npx http-server` หรือ `python -m http.server`).

## โครงสร้างโปรเจ็ค

- `index.html` — หน้าเริ่มต้นและตัวโหลดสคริปต์
- `editor/`
  - `editor.js` — entry point ของแอป, โหลดบริการ/โมดูล/ปลั๊กอิน
  - `core/` — ยูทิลิตี้หลัก
    - `eventBus.js` — ระบบเหตุการณ์ (EventBus)
    - `domUtils.js`, `moduleManager.js`, `uiManager.js` — ตัวช่วยต่างๆ
  - `modules/` — โมดูล UI (toolbar, componentPanel, contentEditor, ฯลฯ)
  - `services/` — บริการเก็บ/โหลดเทมเพลต (`storageService.js`, `templateSaver.js`, `templateLoader.js`)
  - `plugins/` — ปลั๊กอินคอมโพเนนต์ (header, hero, footer, ฯลฯ)

## การพัฒนา

- เปิด `index.html` แล้วลองทำงานกับ UI
- หากต้องการ server สำหรับทดสอบ cross-origin/XHR ใช้คำสั่งอย่างเช่น:

```bash
# Simple static server (Node)
npx http-server . -p 8080
# Or Python 3
python -m http.server 8080
```

จากนั้นเปิด `http://localhost:8080/index.html`