/**
 * Card Plugin - ปลั๊กอินสำหรับการ์ดเนื้อหา
 */
(function(global) {
  'use strict';

  /**
   * คลาส CardPlugin
   * ปลั๊กอินสำหรับการ์ดเนื้อหา
   */
  class CardPlugin {
    constructor(editor) {
      this.editor = editor;
      this.name = 'card';
      this.title = 'การ์ด';
      this.icon = 'style';
      this.description = 'การ์ดเนื้อหา';
    }

    /**
     * เริ่มต้นปลั๊กอิน
     */
    init() {
      if (this.editor.config.debug) {
        console.log('CardPlugin เริ่มต้นแล้ว');
      }
    }

    /**
     * รับเทมเพลตของปลั๊กอิน
     */
    getTemplate() {
      return `
                <div class="editor-component card" data-component="card">
                    <div class="card-image">
                        <img src="https://picsum.photos/seed/card/400/250.jpg" alt="รูปภาพการ์ด">
                    </div>
                    <div class="card-content">
                        <h3 data-editable="true">หัวข้อการ์ด</h3>
                        <p data-editable="true">นี่คือเนื้อหาของการ์ด สามารถแก้ไขได้ตามต้องการ การ์ดนี้สามารถใช้สำหรับแสดงข้อมูลหรือเนื้อหาต่างๆ</p>
                        <a href="#" class="btn btn-primary" data-editable="true">อ่านเพิ่มเติม</a>
                    </div>
                </div>
            `;
    }

    /**
     * รับ CSS ของปลั๊กอิน
     */
    getCSS() {
      return `
                .card {
                    background-color: white;
                    border-radius: 8px;
                    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
                    overflow: hidden;
                    transition: transform 0.3s, box-shadow 0.3s;
                    max-width: 400px;
                }

                .card:hover {
                    transform: translateY(-5px);
                    box-shadow: 0 8px 16px rgba(0,0,0,0.15);
                }

                .card-image {
                    width: 100%;
                    height: 200px;
                    overflow: hidden;
                }

                .card-image img {
                    width: 100%;
                    height: 100%;
                    object-fit: cover;
                    transition: transform 0.3s;
                }

                .card:hover .card-image img {
                    transform: scale(1.05);
                }

                .card-content {
                    padding: 20px;
                }

                .card-content h3 {
                    margin: 0 0 15px 0;
                    font-size: 22px;
                    color: #333;
                }

                .card-content p {
                    margin: 0 0 20px 0;
                    color: #666;
                    line-height: 1.6;
                }

                .btn {
                    display: inline-block;
                    padding: 10px 20px;
                    border-radius: 4px;
                    font-weight: 500;
                    cursor: pointer;
                    transition: all 0.2s;
                    text-decoration: none;
                    font-family: inherit;
                }

                .btn-primary {
                    background-color: #2196F3;
                    color: white;
                    border: none;
                }

                .btn-primary:hover {
                    background-color: #1976D2;
                }

                @media (max-width: 768px) {
                    .card {
                        max-width: 100%;
                    }

                    .card-image {
                        height: 150px;
                    }

                    .card-content h3 {
                        font-size: 20px;
                    }
                }
            `;
    }

    /**
     * รับการตั้งค่าของปลั๊กอิน
     */
    getSettings() {
      return {
        imageHeight: {
          type: 'number',
          label: 'ความสูงรูปภาพ (px)',
          min: 100,
          max: 500,
          default: 200
        },
        showImage: {
          type: 'checkbox',
          label: 'แสดงรูปภาพ',
          default: true
        },
        backgroundColor: {
          type: 'color',
          label: 'สีพื้นหลัง',
          default: '#ffffff'
        },
        titleColor: {
          type: 'color',
          label: 'สีหัวข้อ',
          default: '#333333'
        },
        textColor: {
          type: 'color',
          label: 'สีข้อความ',
          default: '#666666'
        },
        buttonColor: {
          type: 'color',
          label: 'สีปุ่ม',
          default: '#2196F3'
        },
        hoverEffect: {
          type: 'checkbox',
          label: 'เอฟเฟกต์เมื่อชี้',
          default: true
        }
      };
    }
  }

  // เปิดเผยคลาส CardPlugin ทั่วโลก
  global.CardPlugin = CardPlugin;

})(typeof window !== 'undefined' ? window : this);