# Web Lesson — เรียนเขียนเว็บแบบ Step-by-Step

เอกสารแนะนำโปรเจ็ค "Web Lesson" — ชุดบทเรียนสำหรับผู้เริ่มต้นเขียนเว็บ พร้อม UI แบบง่ายและตัวช่วยไฮไลต์โค้ด

## ภาพรวม
โปรเจ็คนี้เป็นชุดหน้า HTML แบบสถิต (static) สำหรับสอนพื้นฐานการเขียนเว็บ (HTML, CSS, JavaScript, ฯลฯ)
มี sidebar นำทาง, progress bar, และระบบแสดงโค้ดที่ถูกปรับแต่งให้สวยงาม (SyntaxHighlighterComponent)
ธีมหลักเป็นโทนสีฟ้าและใช้ฟอนต์ไทย (Kanit) สำหรับการอ่านที่ดี

## คุณสมบัติเด่น
- ธีมสีฟ้า ทันสมัย และ responsive
- ฟอนต์ภาษาไทยจาก Google Fonts (`Kanit`) และฟอนต์โมโนสเปซสำหรับโค้ด
- SyntaxHighlighterComponent: ไฮไลต์โค้ด, เลขบรรทัด, ปุ่มคัดลอก, แสดงชื่อภาษา, พับโค้ด (option)
- โหลดเนื้อหาแบบไดนามิกด้วย `script.js` (fetch บทเรียนจากโฟลเดอร์ `lessons/`)

## โครงสร้างไฟล์สำคัญ
```
/mnt/Server/htdocs/web-lesson
├─ index.html                # หน้าแรก และจุดเริ่มต้นของ UI
├─ script.js                 # โหลดบทเรียน, อัปเดต sidebar/progress, เรียกใช้งาน syntax component
├─ styles.css                # สไตล์หลักของเว็บ
├─ SyntaxHighlighterComponent.js  # คอมโพเนนต์ไฮไลต์โค้ด (custom)
├─ syntaxhighlightercomponent.css  # (ถ้ามี) สไตล์เพิ่มเติมสำหรับ component
└─ lessons/
   ├─ 00-intro.html
   ├─ 01-html.html
   ├─ 02-css.html
   └─ ...
```

> หมายเหตุ: บางไฟล์อาจอยู่ใน root หรือ subfolder ตามการปรับแต่งของคุณ

## เริ่มใช้งาน (รันแบบ local)
คุณสามารถเปิดโฟลเดอร์นี้ด้วยเว็บเซิร์ฟเวอร์ท้องถิ่น (recommended) เช่น Python HTTP server:

```bash
# จากโฟลเดอร์ /mnt/Server/htdocs/web-lesson
python3 -m http.server 8000
# แล้วเปิด http://localhost:8000 ในเบราว์เซอร์
```

หรือถ้าคุณชอบ `serve` (node):

```bash
npx serve . -p 8000
```

## วิธีเพิ่มบทเรียนใหม่
1. สร้างไฟล์ใหม่ในโฟลเดอร์ `lessons/` เช่น `08-new-topic.html`
2. ใน `script.js` เพิ่มรายการบทเรียนในอาร์เรย์ `lessons` (id, title, file)
3. ใช้โครงสร้าง HTML เดียวกับไฟล์อื่น ๆ — ใช้ `<pre><code class="language-...">` สำหรับบล็อกโค้ด

ตัวอย่างโค้ดที่ควรใช้ในบทเรียน (สำหรับไฮไลต์):

```html
<pre><code class="language-html">&lt;!DOCTYPE html&gt;
&lt;html lang="th"&gt;
  &lt;head&gt;...&lt;/head&gt;
  &lt;body&gt;...&lt;/body&gt;
&lt;/html&gt;</code></pre>
```

หรือ หากต้องการให้คอมโพเนนต์ทำงานจาก `data-component`:

```html
<div data-component="syntaxhighlighter" data-language="javascript">
  // โค้ดที่เป็น plain text หรือจะใส่ <pre><code> ก็ได้
</div>
```

## SyntaxHighlighterComponent — ใช้งานอย่างไร
- ไฟล์คอมโพเนนต์อยู่ที่ `SyntaxHighlighterComponent.js` และจะถูกโหลดจาก `index.html`
- เมื่อลูกเพจถูกโหลด (โดย `script.js`) คอมโพเนนต์จะถูกเรียก `SyntaxHighlighterComponent.init()` เพื่อลงทะเบียนและไฮไลต์โค้ด
- คุณสามารถปรับพารามิเตอร์เริ่มต้นได้ในอ็อบเจ็กต์ `config` ภายในไฟล์นั้น เช่น เปิด/ปิด `lineNumbers`, `copyButton`, `codeFolding`, หรือเพิ่มภาษา

ตัวอย่างใช้ API แบบโปรแกรม:

```js
// เรียกใช้งานกับ element ที่มี <code> หรือ <pre>
const instance = SyntaxHighlighterComponent.create(document.querySelector('pre > code'));

// เปลี่ยนโค้ด หรือภาษา
instance.setCode('console.log("hello")');
instance.setLanguage('javascript');

// รีเฟรชการแสดงผล
instance.refresh();
```

## ปรับแต่งธีมและสไตล์
- แก้ `styles.css` เพื่อปรับสี ฟอนต์ ขนาด หรือช่องว่าง
- มีส่วนของ CSS สำหรับคอมโพเนนต์ (class `.highlighted-code`, `.code-header`, `.copy-button` ฯลฯ) คุณสามารถปรับให้เข้ากับธีมของเว็บได้

## Accessibility (คำแนะนำ)
- เพิ่ม `aria-label` และ `role="navigation"` ให้กับ sidebar เพื่อช่วย screen readers
- ให้ปุ่มและลิงก์มี :focus-visible style เพื่อให้ผู้ใช้คีย์บอร์ดเห็นตำแหน่งโฟกัส
- ตรวจสอบ contrast ของสีโดยเครื่องมือเช่น WebAIM

## ปัญหาที่อาจพบ และวิธีตรวจสอบ
- โค้ดไม่ถูกไฮไลต์: ตรวจสอบว่า `<code>` มี class `language-...` หรือว่า `SyntaxHighlighterComponent.js` ถูกโหลด (ดูใน DevTools > Network)
- ปุ่มคัดลอกไม่ทำงาน: Clipboard API ต้องรันจาก secure context หรือ localhost; ตรวจสอบ Console log สำหรับข้อผิดพลาด
- ฟอนต์ไม่แสดง: ตรวจสอบการเชื่อมต่อ Google Fonts หรือพิจารณา self-host ฟอนต์

## การตรวจสอบโค้ด (Lint) และ CI

- โปรเจ็คนี้มีการตั้งค่า ESLint แบบพื้นฐาน หากต้องการรันตรวจโค้ดภายในเครื่องให้ติดตั้ง dependency ด้วย `npm install` แล้วรัน:

```bash
# ติดตั้ง dev dependencies
npm install

# รัน linter
npm run lint
```

- มี GitHub Actions workflow เบื้องต้นที่รัน ESLint ทุกครั้งเมื่อ push/pull request เข้าสู่ branch `main` (ไฟล์: `.github/workflows/ci.yml`).

## Editor & Quiz Scaffolding (Sprint-1)

- `editor-skeleton.js`: modal editor เบา ๆ ที่เปิด CodeMirror บน demand โดยอาศัย attribute `data-action="open-editor"` (ตัวอย่าง: `<button data-action="open-editor" data-code="<h1>Hello</h1>" data-mode="html">Open</button>`)
- `quiz.js`: engine สำหรับคำถามแบบ multiple-choice, บันทึกผลใน `localStorage` (key: `weblesson_quiz_scores_v1`). ตัวอย่างไฟล์ตัวอย่าง: `lessons/exercises/sprint1-samples.json`.

หากต้องการ ผมช่วยเชื่อม UI ในแต่ละบทเรียนให้เรียกใช้งาน Editor/Quiz อัตโนมัติได้ครับ

## การพัฒนา / ทดสอบ
- ใช้เว็บเซิร์ฟเวอร์ท้องถิ่น (ด้านบน) และเปิด DevTools เพื่อตรวจ console/network
- หากแก้ไฟล์ JS/CSS ให้รีเฟรชหน้า และถ้าใช้ cache ให้ hard refresh (Ctrl+F5)

## ร่วมพัฒนา
- แก้ไข/improve ไฟล์ `SyntaxHighlighterComponent.js` เพื่อเพิ่มภาษา/รูปแบบ token
- แก้ `styles.css` เพื่อปรับธีมตามความต้องการ
- หากต้องการ ผมสามารถช่วยแปะ unit tests เล็ก ๆ สำหรับฟังก์ชัน parser/tokenizer (ออกแบบเป็น Node script) เพื่อความมั่นใจ

## ลิขสิทธิ์
- ใส่ไฟล์ LICENSE ถ้าต้องการกำหนดเงื่อนไขการใช้งาน (เช่น MIT)

---

ถ้าต้องการ ผมช่วยอัปเดต README ให้มีรายละเอียดเชิงเทคนิคเพิ่มขึ้น (เช่น ตัวอย่าง API ของ SyntaxHighlighterComponent ทั้งหมด, รูปแบบ token, หรือขั้นตอน self-host ฟอนต์) — บอกผมได้เลยว่าต้องการเพิ่มอะไรอีกครับ!