/* eslint-env browser */
/* global QuizEngine */
// Small UI helpers for rendering widgets inside lesson content

const UIWidgets = (function() {
  function renderQuizList(container, questions) {
    container.innerHTML = '';
    questions.forEach(q => {
      const qWrap = document.createElement('div');
      qWrap.className = 'quiz-item';
      const qTitle = document.createElement('h4');
      qTitle.textContent = q.question;
      qWrap.appendChild(qTitle);
      const btn = document.createElement('button');
      btn.className = 'btn btn-primary';
      btn.textContent = 'เริ่มทำแบบทดสอบ';
      btn.addEventListener('click', () => QuizEngine.renderQuestion(container, q));
      qWrap.appendChild(btn);
      container.appendChild(qWrap);
    });
  }

  return {renderQuizList};
})();

window.UIWidgets = UIWidgets;
