# 📝 Sticky Notes - Enhanced PWA

แอปพลิเคชัน Sticky Notes ที่ทำงานแบบ offline พร้อมฟีเจอร์ครบครัน

## ✨ ฟีเจอร์หลัก

### 🎨 การจัดรูปแบบข้อความ
- **Markdown Support** - เขียน Markdown และดูตัวอย่างแบบ real-time
- **Rich Text Editing** - จัดรูปแบบข้อความด้วย toolbar (Bold, Italic, Underline, Lists)
- รองรับ headings, links, code blocks, และอื่นๆ

### ⏰ Reminders
- ตั้งเตือนสำหรับโน้ตที่สำคัญ
- แจ้งเตือนผ่าน browser notification
- แสดง reminder indicator บนโน้ต

### 📁 Categories
- จัดกลุ่มโน้ตด้วยหมวดหมู่
- กรองโน้ตตามหมวดหมู่
- สร้างหมวดหมู่ใหม่ได้ง่าย

### 📋 Templates
เทมเพลตสำเร็จรูป 6 แบบ:
- ✓ **To-Do List** - รายการสิ่งที่ต้องทำ
- 📋 **Meeting Notes** - บันทึกการประชุม
- 💡 **Ideas** - ไอเดียและแนวคิด
- 🎯 **Goals** - เป้าหมายและความสำเร็จ
- 🛒 **Shopping List** - รายการช้อปปิ้ง
- 📝 **Blank Note** - โน้ตเปล่า

### 📊 Kanban Board
- มุมมองแบบ Kanban สำหรับจัดการงาน
- 3 คอลัมน์: To Do, In Progress, Done
- ลากและวางเพื่อเปลี่ยนสถานะ
- สลับระหว่าง Sticky view และ Kanban view ได้

### 📱 Mobile Optimized
- ปรับปรุง touch controls สำหรับมือถือ
- Responsive design ทำงานได้ทุกหน้าจอ
- Swipe gestures และ touch-friendly buttons
- PWA - ติดตั้งเป็นแอปบนมือถือได้

### 🎯 ฟีเจอร์อื่นๆ
- 🌙 Dark mode
- 📌 Pin โน้ตสำคัญ
- 🎨 เปลี่ยนสีโน้ต
- #️⃣ Tags อัตโนมัติ
- 🔍 ค้นหาโน้ต
- 💾 Export/Import
- 🗑️ Recycle bin
- ⌨️ Keyboard shortcuts

## 🚀 การใช้งาน

### การสร้างโน้ต
1. คลิก **+ New Note** เพื่อสร้างโน้ตเปล่า
2. คลิก **Templates** เพื่อเลือกเทมเพลต
3. ลากโน้ตเพื่อย้ายตำแหน่ง
4. ลากมุมล่างขวาเพื่อปรับขนาด

### Markdown
1. คลิกไอคอน `<>` บนโน้ตเพื่อเปิด Markdown mode
2. เขียน Markdown syntax:
   - `**bold**` สำหรับตัวหนา
   - `*italic*` สำหรับตัวเอียง
   - `# Heading` สำหรับหัวข้อ
   - `- List item` สำหรับรายการ
   - `` `code` `` สำหรับโค้ด
3. คลิกไอคอน `<>` อีกครั้งเพื่อกลับไปแก้ไข

### Rich Text
1. คลิกในโน้ตเพื่อแก้ไข
2. Toolbar จะปรากฏขึ้นอัตโนมัติ
3. เลือกข้อความและคลิกปุ่มจัดรูปแบบ

### Reminders
1. คลิกเมนู (⋮) บนโน้ต
2. เลือก "⏰ Set Reminder"
3. ใส่วันที่และเวลา (YYYY-MM-DD HH:MM)
4. จะได้รับการแจ้งเตือนก่อนถึงเวลา 5 นาที

### Categories
1. คลิกเมนู (⋮) บนโน้ต
2. เลือก "📁 Set Category"
3. ใส่ชื่อหมวดหมู่
4. กรองโน้ตด้วย dropdown ที่ toolbar

### Kanban View
1. คลิกปุ่ม **Kanban** ที่ toolbar
2. ลากโน้ตระหว่างคอลัมน์เพื่อเปลี่ยนสถานะ
3. คลิกโน้ตเพื่อกลับไปแก้ไขใน Sticky view

## ⌨️ Keyboard Shortcuts

- `N` - สร้างโน้ตใหม่
- `Ctrl/Cmd + S` - Export โน้ต
- `Delete` - ลบโน้ตที่เลือก
- `Ctrl/Cmd + Z` - กู้คืนโน้ตที่ลบล่าสุด
- `Esc` - ปิด modal

## 🛠️ เทคโนโลยี

- **Vanilla JavaScript** - ไม่ใช้ framework
- **Marked.js** - Markdown parser
- **LocalStorage** - เก็บข้อมูลแบบ offline
- **Service Worker** - PWA support
- **CSS Grid & Flexbox** - Responsive layout
- **Material Symbols** - Icons

## 📦 การติดตั้ง

1. เปิดแอปในเบราว์เซอร์
2. คลิกปุ่ม "Install" หรือ "Add to Home Screen"
3. ใช้งานแบบ offline ได้เลย

## 🌐 Browser Support

- Chrome/Edge (แนะนำ)
- Firefox
- Safari
- Opera

## 📄 License

MIT License - ใช้งานได้ฟรี

---

Made with ❤️ by Goragod Wiriya
