const CACHE_NAME = 'dev-meme-forge-v1.1';
const urlsToCache = [
  '/',
  '/index.html',
  '/style.css',
  '/script.js',
  '/templates.js',
  '/enhanced.js',
  '/manifest.json',
  '/favicon.svg',
  '/img/icon-192.png',
  '/img/icon-512.png',
  // Template img
  '/img/templates/distracted-boyfriend.jpg',
  '/img/templates/drake-pointing.jpg',
  '/img/templates/this-is-fine.jpg',
  '/img/templates/expanding-brain.jpg',
  '/img/templates/two-buttons.jpg',
  '/img/templates/change-my-mind.jpg',
  '/img/templates/mocking-spongebob.jpg',
  '/img/templates/stonks.jpg',
  '/img/templates/woman-yelling-at-cat.jpg',
  '/img/templates/left-exit-12.jpg',
  '/img/templates/uno-draw-25.jpg',
  '/img/templates/panik-kalm-panik.jpg',
  '/img/templates/bernie-asking.jpg',
  '/img/templates/is-this-a-pigeon.jpg',
  '/img/templates/surprised-pikachu.jpg',
  '/img/templates/one-does-not-simply.jpg',
  '/img/templates/futurama-fry.jpg',
  '/img/templates/disaster-girl.jpg',
  '/img/templates/success-kid.jpg',
  '/img/templates/grumpy-cat.jpg',
  '/img/templates/always-has-been.jpg',
  '/img/templates/hide-the-pain-harold.jpg',
  '/img/templates/waiting-skeleton.jpg'
];

// Install event
self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(CACHE_NAME)
      .then(function(cache) {
        return cache.addAll(urlsToCache);
      })
  );
});

// Fetch event
self.addEventListener('fetch', function(event) {
  event.respondWith(
    caches.match(event.request)
      .then(function(response) {
        // Return cached version or fetch from network
        if (response) {
          return response;
        }
        return fetch(event.request);
      }
      )
  );
});

// Activate event
self.addEventListener('activate', function(event) {
  event.waitUntil(
    caches.keys().then(function(cacheNames) {
      return Promise.all(
        cacheNames.map(function(cacheName) {
          if (cacheName !== CACHE_NAME) {
            return caches.delete(cacheName);
          }
        })
      );
    })
  );
});
