# Meme Forge Pro

**"เปลี่ยนบั๊กเป็นเสียงฮา โค้ดปัญหาให้เป็นมีม!"**

เว็บไซต์สำหรับสร้างมีมที่เน้นไปที่กลุ่มนักพัฒนาซอฟต์แวร์ นักวิทยาศาสตร์ข้อมูล และผู้ที่สนใจเทคโนโลยี AI

[![GitHub license](https://img.shields.io/github/license/goragodwiriya/meme-forge-pro)](https://github.com/goragodwiriya/meme-forge-pro/blob/main/LICENSE)
[![GitHub stars](https://img.shields.io/github/stars/goragodwiriya/meme-forge-pro)](https://github.com/goragodwiriya/meme-forge-pro/stargazers)
[![GitHub issues](https://img.shields.io/github/issues/goragodwiriya/meme-forge-pro)](https://github.com/goragodwiriya/meme-forge-pro/issues)

## ฟีเจอร์หลัก

### 🎨 Advanced Meme Generator
- **22+ เทมเพลต**: เทมเพลตมีมยอดนิยมพร้อมใช้
- **อัปโหลดรูปภาพ**: อัปโหลดรูปภาพของคุณเองมาทำมีม
- **แก้ไขข้อความ**: เพิ่มข้อความบนและล่างพร้อมฟอนต์ที่เหมาะสม
- **🆕 Drag & Drop Text**: ลากและวางข้อความได้ทุกตำแหน่ง
- **ดาวน์โหลด**: ดาวน์โหลดมีมคุณภาพสูงเป็นไฟล์ PNG

### 🌙 Dark/Light Theme
- รองรับทั้งธีมมืดและธีมสว่าง
- จดจำการตั้งค่าธีมของผู้ใช้

### 📱 Responsive Design
- ใช้งานได้ดีทั้งบน Desktop, Tablet, และ Mobile
- การจัดวางแบบ Grid ที่ปรับตัวได้

## 🎯 การใช้งาน

### ขั้นตอนการสร้างมีม

1. **📖 เลือกเทมเพลต**:
   - เลือกจากเทมเพลตยอดนิยม 22+ แบบ หรือ
   - อัปโหลดรูปภาพของคุณเอง

2. **✏️ เพิ่มข้อความ**:
   - พิมพ์ข้อความในช่อง "ข้อความบน" และ "ข้อความล่าง"
   - ข้อความจะปรากฏแบบ Real-time บน Canvas

3. **🎯 จัดตำแหน่ง**:
   - **คลิกและลาก** ข้อความบน Canvas เพื่อย้ายตำแหน่ง
   - ดูตำแหน่ง X%, Y% แบบ live
   - ใช้ปุ่ม "รีเซ็ตตำแหน่ง" เพื่อกลับค่าเริ่มต้น

4. **💾 ดาวน์โหลด**:
   - คลิกปุ่ม "ดาวน์โหลดมีม" เพื่อบันทึกเป็น PNG คุณภาพสูง

### 💡 เทคนิคการใช้งาน
- 📱 **บนมือถือ**: แตะและลากข้อความได้เหมือน desktop
- ⌨️ **Keyboard**: ใช้ Tab เพื่อ navigate, Enter เพื่อ download
- 🌙 **ธีม**: คลิกปุ่มสลับธีมมุมขวาบนเพื่อเปลี่ยน Dark/Light mode

## 🛠️ เทคโนโลยีที่ใช้

### Frontend
- **HTML5** - โครงสร้างและ semantic markup
- **CSS3** - styling, animations, และ responsive design
- **Vanilla JavaScript** - logic และ interactions
- **Canvas API** - การสร้างและแก้ไขมีม

### Design & UX
- **Glassmorphism Design** - ดีไซน์แก้วทันสมัย
- **Responsive Grid System** - รองรับทุกขนาดหน้าจอ
- **Progressive Web App (PWA)** - ติดตั้งได้เป็น app
- **Service Worker** - caching และ offline support

### Features
- **Drag & Drop API** - ระบบลากข้อความ
- **File API** - อัปโหลดรูปภาพ
- **Local Storage** - บันทึกธีมและการตั้งค่า
- **Touch Events** - รองรับ mobile และ tablet

## 🚀 การติดตั้งและเรียกใช้

### วิธีที่ 1: ใช้งานออนไลน์
เข้าใช้งานได้ทันทีที่: **[https://goragodwiriya.github.io/meme-forge-pro/](https://goragodwiriya.github.io/meme-forge-pro/)**

### วิธีที่ 2: รันบนเครื่องตัวเอง

#### ข้อกำหนดระบบ
- เว็บเบราว์เซอร์ที่รองรับ HTML5 Canvas (Chrome, Firefox, Safari, Edge)
- HTTP Server (สำหรับ development)

#### ขั้นตอนการติดตั้ง

1. **Clone Repository**
```bash
git clone https://github.com/goragodwiriya/meme-forge-pro.git
cd meme-forge-pro
```

2. **เริ่มต้น HTTP Server**

**Python (แนะนำ):**
```bash
python -m http.server 8000
# หรือ
python3 -m http.server 8000
```

**Node.js:**
```bash
npx http-server -p 8000
```

**PHP:**
```bash
php -S localhost:8000
```

3. **เปิดเว็บเบราว์เซอร์**
```
http://localhost:8000
```

4. **เริ่มสร้างมีมได้เลย! 🎉**

### 🌐 PWA Support
- รองรับการติดตั้งเป็น Progressive Web App
- ใช้งานได้แบบ offline (บางฟีเจอร์)
- รองรับ Service Worker สำหรับ caching

## กลุ่มเป้าหมาย

- 👨‍💻 โปรแกรมเมอร์และนักพัฒนาซอฟต์แวร์
- 🤖 นักวิทยาศาสตร์ข้อมูลและวิศวกร AI/ML
- 🎓 นักศึกษา Computer Science/IT
- 💡 ผู้ที่สนใจเทคโนโลยีและ AI

## 🆕 ฟีเจอร์ใหม่ล่าสุด

### 🎯 Drag & Drop Text Positioning
- **คลิกและลาง**: คลิกข้อความบน canvas แล้วลากไปตำแหน่งที่ต้องการ
- **ตำแหน่งไม่จำกัด**: สามารถวางข้อความได้ทุกตำแหน่งบน canvas
- **Visual Feedback**: มีเส้นไขว้และจุดช่วยจัดตำแหน่ง
- **Live Positioning**: แสดงตำแหน่ง X, Y เป็น % แบบ real-time
- **Touch Support**: รองรับการลากบนมือถือและแท็บเล็ต
- **Haptic Feedback**: การสั่นเมื่อจับและวางข้อความ (บนมือถือ)

### 📍 Position Display System
- แสดงตำแหน่งแบบ percentage (X%, Y%)
- Tooltip แสดงตำแหน่งปัจจุบันเมื่อ hover หรือลาง
- ปุ่มรีเซ็ตตำแหน่งกลับค่าเริ่มต้น
- Animation เมื่อรีเซ็ตตำแหน่ง

### 🎮 Enhanced User Experience
- Cursor states: grab/grabbing เมื่อ hover/drag
- Toast notifications เมื่อทำงานสำเร็จ
- Visual effects: glow และ scale เมื่อ interact
- Better hit detection สำหรับการจับข้อความ
- Error handling และ performance optimization

### 📱 Mobile Optimizations
- Touch-friendly interface
- Responsive tooltips
- Enhanced mobile instructions
- Better touch feedback
- Optimized for various screen sizes

## 📸 Screenshots

### Desktop View
![Desktop Screenshot](img/screenshot-desktop.png)
*การใช้งานบน Desktop - Controls และ Canvas อยู่ข้างกัน*

### Mobile View
![Mobile Screenshot](img/screenshot-mobile.png)
*การใช้งานบนมือถือ - Layout แบบ responsive*

### Features Showcase
- 🎨 **Template Gallery** - เทมเพลตมีมยอดนิยม 22+ แบบ
- 🎯 **Drag & Drop** - ลากข้อความไปตำแหน่งไหนก็ได้
- 📱 **Mobile Optimized** - ใช้งานสะดวกบนทุกอุปกรณ์
- 🌙 **Dark/Light Theme** - เลือกธีมตามความชอบ

## 🎮 Demo & Live Preview

### 🌐 Live Demo
**[👉 ทดลองใช้งาน Meme Forge Pro](https://goragodwiriya.github.io/meme-forge-pro/)**

### 📱 PWA Installation
1. เปิดเว็บไซต์บนมือถือ
2. เลือก "Add to Home Screen"
3. ใช้งานเป็น native app

## 👨‍💻 ผู้พัฒนา

**Goragod Wiriya**
- 🐙 GitHub: [@goragodwiriya](https://github.com/goragodwiriya)
- 💼 เป็นนักพัฒนาที่หลงใหลในการสร้าง tools ที่มีประโยชน์สำหรับชุมชนนักพัฒนา
- 🎯 มุ่งมั่นสร้างโปรเจกต์ที่ช่วยให้การทำงานสนุกและมีประสิทธิภาพมากขึ้น

## 🤝 การมีส่วนร่วม

ยินดีต้อนรับ Contributions จากทุกคน! 🎉

### วิธีการมีส่วนร่วม

1. **🍴 Fork** repository นี้
2. **🌟 Clone** ไปยังเครื่องของคุณ
3. **🔧 สร้าง** feature branch ใหม่
   ```bash
   git checkout -b feature/amazing-feature
   ```
4. **✏️ Commit** การเปลี่ยนแปลง
   ```bash
   git commit -m 'Add: เพิ่มฟีเจอร์สุดเจ๋ง'
   ```
5. **📤 Push** ไปยัง branch
   ```bash
   git push origin feature/amazing-feature
   ```
6. **🔀 เปิด** Pull Request

### 💡 แนวทางการ Contribute

- **🐛 Bug Reports** - รายงาน bug พร้อมขั้นตอนการทำซ้ำ
- **✨ Feature Requests** - เสนอฟีเจอร์ใหม่ที่น่าสนใจ
- **📖 Documentation** - ปรับปรุงเอกสารและคำอธิบาย
- **🎨 UI/UX Improvements** - ปรับปรุงดีไซน์และ user experience
- **🔧 Code Optimization** - เพิ่มประสิทธิภาพและลดขนาดไฟล์

### 📋 Guidelines

- ใช้ commit message ที่ชัดเจน
- เขียน code ที่อ่านง่ายและมี comment
- ทดสอบบนหลายเบราว์เซอร์
- รักษา responsive design
- ตรวจสอบ accessibility

## 📄 License

```
MIT License

Copyright (c) 2568 Goragod Wiriya

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

## 🙏 ขอบคุณ

### 💖 พิเศษขอบคุณ
- **ชุมชน Developer ไทย** - ที่ให้แรงบันดาลใจและ feedback
- **Open Source Community** - ที่สร้างเครื่องมือและ library ที่ยอดเยี่ยม
- **Meme Culture** - ที่ทำให้ชีวิตการเขียนโปรแกรมสนุกขึ้น! 😄

### 🌟 Inspiration
โปรเจกต์นี้เกิดขึ้นจากความต้องการของนักพัฒนาที่อยากแชร์ความรู้สึกและประสบการณ์การเขียนโค้ดผ่านมีม เพื่อสร้างเสียงหัวเราะและความสุขให้กับชุมชน

---

## 🎉 เริ่มต้นใช้งานเลย!

<div align="center">

### 🚀 [**ลองใช้ Meme Forge Pro ตอนนี้**](https://goragodwiriya.github.io/meme-forge-pro/)

**สร้างมีมที่สื่อถึงชีวิตนักพัฒนาของคุณ**

[![⭐ Star ใน GitHub](https://img.shields.io/badge/⭐-Star%20on%20GitHub-yellow?style=for-the-badge&logo=github)](https://github.com/goragodwiriya/meme-forge-pro)
[![🍴 Fork Project](https://img.shields.io/badge/🍴-Fork%20Project-blue?style=for-the-badge&logo=github)](https://github.com/goragodwiriya/meme-forge-pro/fork)
[![📱 Try PWA](https://img.shields.io/badge/📱-Install%20as%20App-green?style=for-the-badge)](https://goragodwiriya.github.io/meme-forge-pro/)

---

### 📢 แชร์ประสบการณ์ของคุณ!

เมื่อคุณสร้างมีมด้วย Meme Forge Pro แล้ว อย่าลืม:
- 📸 **แชร์มีมที่สร้าง** บน social media
- 🏷️ **ใช้ hashtag** `#MemeForgeProโปรเจกต์`
- ⭐ **ให้ Star** ถ้าชอบและใช้งานได้ดี
- 🐛 **รีพอร์ต Bug** ถ้าเจอปัญหา
- 💡 **เสนอไอเดีย** ฟีเจอร์ใหม่ๆ

</div>

---

**Made with ❤️ for Thai Developer Community**

**Happy Meme Making! 🎉 มีความสุขกับการสร้างมีม!**
