# Smoothie Paradise - ร้านน้ำปั่นออนไลน์

A beautiful and responsive Thai smoothie shop website built with vanilla HTML, CSS, and JavaScript. Features a modern glass-morphism design with smooth animations and a fully functional shopping cart.

## 🌟 Features

- **Responsive Design**: Works perfectly on desktop, tablet, and mobile devices
- **Modern UI**: Glass-morphism design with smooth animations and transitions
- **Shopping Cart**: Add, remove, and manage items with real-time updates
- **Thai Language**: Fully localized in Thai language
- **Interactive Product Cards**: Hover effects and smooth transitions
- **Sticky Header**: Navigation stays visible while scrolling
- **Notification System**: Toast notifications for user actions
- **Product Management**: 8 different smoothie and beverage options

## 🍹 Products Available

- สตรอเบอร์รี่ สมูทตี้ (Strawberry Smoothie) - ฿69
- มะม่วง สมูทตี้ (Mango Smoothie) - ฿75
- กล้วยหอม สมูทตี้ (Banana Smoothie) - ฿59
- ผลไม้รวม สมูทตี้ (Mixed Fruit Smoothie) - ฿85
- ชาเขียว มัทฉะ (Green Tea Matcha) - ฿79
- กาแฟเย็น (Iced Coffee) - ฿49
- ชาไทย (Thai Tea) - ฿45
- น้ำส้มคั้นสด (Fresh Orange Juice) - ฿55

## 🚀 Getting Started

### Prerequisites

- A modern web browser (Chrome, Firefox, Safari, Edge)
- A local web server (optional, for development)

### Installation

1. Clone or download the repository
2. Open `index.html` in your web browser
3. Or serve it using a local web server:

```bash
# Using Python 3
python -m http.server 8000

# Using Node.js (http-server)
npx http-server

# Using PHP
php -S localhost:8000
```

## 📱 Usage

### Adding Products to Cart
1. Browse through the available smoothies and beverages
2. Click the "เพิ่มลงตะกร้า" (Add to Cart) button on any product
3. View the cart counter update in the header

### Managing Cart
1. Click the "ตะกร้าสินค้า" (Shopping Cart) button in the header
2. Use the + and - buttons to adjust quantities
3. Items with quantity 0 are automatically removed
4. View real-time total calculations

### Checkout Process
1. Review items in your cart
2. Click "สั่งซื้อตอนนี้" (Order Now) button
3. Confirm your order in the popup dialog

## 🎨 Design Features

### Visual Elements
- **Glass-morphism Effect**: Semi-transparent backgrounds with blur effects
- **Gradient Backgrounds**: Beautiful color gradients throughout the design
- **Material Icons**: Google Material Icons for consistent iconography
- **Smooth Animations**: CSS transitions and transforms for interactive elements

### Color Palette
- Primary: `#667eea` (Blue gradient start)
- Secondary: `#764ba2` (Purple gradient end)
- Accent: `#ff4757` (Red for notifications)
- Success: `#4caf50` (Green for notifications)

### Typography
- **Font Family**: Kanit (Thai web font from Google Fonts)
- **Weights**: 200, 300, 400, 500, 600, 700

## 📁 File Structure

```
smoothie-shop/
├── index.html          # Main application file
└── README.md           # Project documentation
```

## 🔧 Technical Details

### Technologies Used
- **HTML5**: Semantic markup and structure
- **CSS3**: Modern styling with Flexbox, Grid, and advanced properties
- **Vanilla JavaScript**: No frameworks, pure JavaScript functionality
- **Google Fonts**: Kanit font family for Thai language support
- **Material Icons**: Icon set for consistent UI elements

### Key JavaScript Functions
- `generateProducts()`: Dynamically creates product cards
- `addToCart(productId)`: Adds items to shopping cart
- `updateCartUI()`: Updates cart display and counters
- `updateQuantity(productId, change)`: Modifies item quantities
- `toggleCart()`: Opens/closes cart sidebar
- `checkout()`: Processes order and shows confirmation
- `showNotification(message)`: Displays toast notifications

### CSS Features
- **CSS Grid**: Responsive product layout
- **Flexbox**: Component alignment and spacing
- **CSS Variables**: Could be added for better theme management
- **Media Queries**: Responsive design for mobile devices
- **Backdrop Filter**: Glass-morphism effects
- **CSS Transitions**: Smooth hover and interaction effects

## 📱 Responsive Design

The website is fully responsive and adapts to different screen sizes:

- **Desktop**: Full grid layout with sidebar cart
- **Tablet**: Adjusted grid columns and spacing
- **Mobile**: Single column layout, full-width cart overlay

### Breakpoints
- Mobile: `max-width: 768px`

## 🔮 Future Enhancements

Potential improvements that could be added:

- **Backend Integration**: Connect to a real database and payment system
- **User Authentication**: Login and user accounts
- **Order History**: Track previous orders
- **Product Categories**: Filter and sort products
- **Search Functionality**: Find products by name or ingredient
- **Favorites**: Save favorite products
- **Multiple Languages**: Add English language support
- **Progressive Web App**: Add PWA features for mobile installation
- **Real Payment Gateway**: Integrate with Thai payment systems

## 🤝 Contributing

This is a single-file project perfect for learning or as a starting point for a larger application. Feel free to:

1. Fork the project
2. Create feature branches
3. Submit pull requests
4. Report issues or suggest improvements

## 📄 License

This project is open source and available under the [MIT License](LICENSE).

## 👨‍💻 Author

Created with ❤️ for smoothie lovers everywhere!

---

*Smoothie Paradise - Where every sip is a taste of paradise! 🏝️*