# 🧾 Receipt Designer - โปรแกรมออกแบบใบเสร็จรับเงิน

โปรแกรมออกแบบใบเสร็จรับเงินออนไลน์ที่ทันสมัย รองรับการแก้ไขแบบ WYSIWYG และการส่งออกเป็น PDF

## ✨ ฟีเจอร์หลัก

- 🎨 **ออกแบบแบบ WYSIWYG** - แก้ไขใบเสร็จแบบเห็นผลทันที
- 📄 **เทมเพลตหลากหลาย** - เลือกเทมเพลตที่เหมาะสมกับธุรกิจ
- 🖼️ **เพิ่มโลโก้** - อัปโหลดโลโก้บริษัทได้ง่ายดาย
- 🎯 **การจัดการข้อมูล** - บันทึกข้อมูลบริษัทและลูกค้าอัตโนมัติ
- 🖨️ **พิมพ์และส่งออก** - พิมพ์ใบเสร็จหรือส่งออกเป็น PDF
- 📱 **รองรับมือถือ** - ใช้งานได้บนทุกอุปกรณ์
- 🔍 **ซูมเข้า-ออก** - ดูรายละเอียดอย่างชัดเจน
- ↩️ **Undo/Redo** - ย้อนกลับและทำซ้ำการแก้ไข

## 🚀 การใช้งาน

### 1. เปิดใช้งาน
เปิดไฟล์ `index.html` ในเว็บเบราว์เซอร์

### 2. เลือกเทมเพลต
- คลิกเลือกเทมเพลตที่ต้องการจากแถบด้านข้าง
- แต่ละเทมเพลตมีสไตล์และเลย์เอาต์ที่แตกต่างกัน

### 3. แก้ไขข้อมูล
- คลิกปุ่ม "แก้ไข" เพื่อเข้าสู่โหมดแก้ไข
- คลิกที่ข้อความที่ต้องการแก้ไข
- ใช้แถบเครื่องมือในการจัดรูปแบบ

### 4. เพิ่มโลโก้
- คลิกปุ่ม "เพิ่มโลโก้"
- อัปโหลดไฟล์รูภาพ
- ปรับขนาดและตำแหน่งตามต้องการ

### 5. พิมพ์หรือส่งออก
- คลิกปุ่ม "พิมพ์" สำหรับการพิมพ์
- คลิกปุ่ม "Export PDF" เพื่อส่งออกเป็นไฟล์ PDF

## 🛠️ เทคโนโลยีที่ใช้

- **HTML5** - โครงสร้างหน้าเว็บ
- **CSS3** - การจัดรูปแบบและภาพเคลื่อนไหว
- **JavaScript (ES6+)** - ฟังก์ชันการทำงานหลัก
- **Font Awesome** - ไอคอน
- **Google Fonts** - ฟอนต์ไทย (Sarabun, Prompt, Kanit)

## 📁 โครงสร้างไฟล์

```
receipt-designer/
├── index.html          # หน้าหลักของแอปพลิเคชัน
├── script.js           # JavaScript หลักสำหรับฟังก์ชันการทำงาน
├── styles.css          # CSS สำหรับการจัดรูปแบบ
└── README.md           # เอกสารประกอบ
```

## 🎯 ฟีเจอร์เด่น

### การแก้ไขแบบ WYSIWYG
- แก้ไขข้อความโดยตรงบนใบเสร็จ
- เปลี่ยนฟอนต์, ขนาด, สี ได้แบบเรียลไทม์
- จัดตำแหน่งข้อความ (ซ้าย, กลาง, ขวา)

### ระบบเทมเพลต
- เทมเพลตคลาสสิก
- เทมเพลตโมเดิร์น
- เทมเพลตมินิมอล
- เทมเพลตโปรเฟสชันนัล

### การจัดการข้อมูล
- บันทึกข้อมูลบริษัทใน LocalStorage
- ข้อมูลลูกค้าและรายการสินค้า
- คำนวณภาษีมูลค่าเพิ่มอัตโนมัติ

## 🔧 การติดตั้งและพัฒนา

### ความต้องการของระบบ
- เว็บเบราว์เซอร์ที่รองรับ HTML5, CSS3, และ JavaScript ES6+
- การเชื่อมต่ออินเทอร์เน็ต (สำหรับ CDN fonts และ icons)

### การรันในเครื่อง
1. ดาวน์โหลดหรือ clone โปรเจ็ค
2. เปิดไฟล์ `index.html` ในเว็บเบราว์เซอร์
3. ไม่จำเป็นต้องติดตั้ง dependencies เพิ่มเติม

### การพัฒนา
- โปรเจ็คนี้เป็น vanilla JavaScript ไม่ต้องใช้ build tools
- แก้ไขไฟล์ได้โดยตรงและรีเฟรชเบราว์เซอร์

## 📱 การรองรับอุปกรณ์

- ✅ Desktop (Chrome, Firefox, Safari, Edge)
- ✅ Tablet (iPad, Android)
- ✅ Mobile (iOS Safari, Chrome Mobile)
- ✅ Responsive Design

## 🤝 การมีส่วนร่วม

หากต้องการมีส่วนร่วมในการพัฒนา:

1. Fork โปรเจ็ค
2. สร้าง feature branch (`git checkout -b feature/AmazingFeature`)
3. Commit การเปลี่ยนแปลง (`git commit -m 'Add some AmazingFeature'`)
4. Push ไปยัง branch (`git push origin feature/AmazingFeature`)
5. เปิด Pull Request

## 📝 License

โปรเจ็คนี้เป็น open source และใช้ภายใต้ [MIT License](LICENSE)

## 👨‍💻 ผู้พัฒนา

**Goragod Wiriya**
- GitHub: [@goragodwiriya](https://github.com/goragodwiriya)
- เว็บไซต์: [https://www.goragod.com](https://www.goragod.com)

## 🙏 ขอบคุณ

- [Font Awesome](https://fontawesome.com/) สำหรับไอคอน
- [Google Fonts](https://fonts.google.com/) สำหรับฟอนต์ไทย
- ชุมชน open source ทั้งหมดที่ให้การสนับสนุน

---

⭐ หากโปรเจ็คนี้มีประโยชน์ อย่าลืมกด Star ให้ด้วยนะครับ!
