# POS System - ระบบจัดการร้านค้าและคลังสินค้า

ระบบจัดการร้านค้าและคลังสินค้าแบบครบวงจร (Point of Sale) พัฒนาด้วย HTML, CSS, Vanilla JavaScript และ PHP สำหรับใช้งานในธุรกิจขนาดเล็กถึงขนาดกลาง ไม่ต้องการการติดตั้งที่ซับซ้อน สามารถใช้งานได้ทันทีผ่านเว็บเบราว์เซอร์

## คุณสมบัติหลัก

### ระบบคลังสินค้า
- การจัดการสินค้า (เพิ่ม/แก้ไข/ลบ)
- การติดตามสต็อกสินค้า
- การแจ้งเตือนสินค้าใกล้หมด
- การจัดการประเภทสินค้า
- การติดตามการเคลื่อนไหวของสินค้า

### ระบบขายหน้าร้าน (POS)
- หน้าจอขายสินค้าที่ใช้งานง่าย
- การค้นหาสินค้าแบบรวดเร็ว
- การจัดการตะกร้าสินค้า
- การคำนวณราคารวมและภาษี
- การรับชำระเงินหลายรูปแบบ (เงินสด, บัตรเครดิต, ฯลฯ)
- การพิมพ์ใบเสร็จ

### ระบบรายงาน
- รายงานยอดขายประจำวัน/สัปดาห์/เดือน
- รายงานสินค้าขายดี
- รายงานสินค้าคงเหลือ
- รายงานการทำงานของพนักงาน
- รายงานภาษี

### ระบบหลังบ้าน (Backend)
- ระบบล็อกอินพร้อมการจัดการสิทธิ์
- การจัดการผู้ใช้และบทบาท
- การตั้งค่าระบบ
- การจัดการข้อมูลร้านค้า

### ระบบ API และความปลอดภัย
- RESTful API สำหรับการเชื่อมต่อกับระบบภายนอก
- การรักษาความปลอดภัยด้วย JWT Authentication
- การป้องกัน SQL Injection และ XSS
- การสำรองและกู้คืนข้อมูล
- การบันทึกประวัติการใช้งาน (Audit Log)

## ข้อกำหนดระบบ

- PHP 7.4 หรือสูงกว่า
- MySQL 5.7 หรือสูงกว่า
- เว็บเซิร์ฟเวอร์ (Apache, Nginx)
- เว็บเบราว์เซอร์ที่รองรับ CSS3 และ JavaScript ES6

## การติดตั้ง

### ขั้นตอนการติดตั้ง

1. สร้างฐานข้อมูลใหม่ชื่อ `pos_system` (หรือชื่ออื่นตามที่ต้องการ)
2. นำเข้าไฟล์ SQL จาก `/database/pos_system.sql` เพื่อสร้างตารางและข้อมูลเริ่มต้น
3. แก้ไขการตั้งค่าการเชื่อมต่อฐานข้อมูลในไฟล์ `/api/config.php`:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_NAME', 'pos_system'); // ชื่อฐานข้อมูลที่สร้าง
   define('DB_USER', 'root'); // ชื่อผู้ใช้ MySQL
   define('DB_PASS', ''); // รหัสผ่าน MySQL
   ```
4. ตั้งค่าคีย์ความปลอดภัยสำหรับ JWT:
   ```php
   define('JWT_SECRET', 'your-secret-key-change-this-in-production');
   ```
5. แก้ไขการตั้งค่า basePath ของ Javascript ตามโฟลเดอร์ที่ติดตั้งโปรแกรม ที่ `/assets/js/config.js`
```javascript
window.basePath = '/pos-system'; // จะได้ URL เป็น http://localhost/pos-system  หรือ ค่าว่าง หากติดตั้งที่ root เพื่อที่จะได้ URL เป็น http://localhost
```

## การเข้าสู่ระบบ

หลังจากติดตั้งเสร็จสิ้น คุณสามารถเข้าสู่ระบบด้วยบัญชีเริ่มต้น:

- **ผู้ดูแลระบบ (Admin)**:
  - ชื่อผู้ใช้: `admin`
  - รหัสผ่าน: `admin`

## ข้อควรระวังและเงื่อนไขการใช้งาน

### ข้อควรระวัง
1. **ความปลอดภัย**: โปรเจคนี้เป็นเพียงต้นแบบเพื่อศึกษาการใช้งาน AI ในการพัฒนาระบบ ไม่ได้รับการตรวจสอบความปลอดภัยอย่างเต็มรูปแบบ ควรเพิ่มมาตรการรักษาความปลอดภัยเพิ่มเติมก่อนนำไปใช้ในสภาพแวดล้อมจริง
2. **การสำรองข้อมูล**: ควรกำหนดกระบวนการสำรองข้อมูลอัตโนมัติเพิ่มเติม เพื่อป้องกันการสูญเสียข้อมูล
3. **การขยายระบบ**: แม้ระบบจะออกแบบให้รองรับการขยายตัว แต่อาจมีข้อจำกัดเมื่อมีข้อมูลจำนวนมาก
4. **เว็บเบราว์เซอร์**: ระบบใช้ JavaScript ES6 จึงต้องการเว็บเบราว์เซอร์รุ่นใหม่

### เงื่อนไขการใช้งาน
1. โปรเจคนี้พัฒนาขึ้นเพื่อวัตถุประสงค์ในการศึกษาการใช้ AI ในการพัฒนาซอฟต์แวร์
2. ไม่รับประกันความถูกต้องหรือความเหมาะสมสำหรับการใช้งานเชิงพาณิชย์
3. ผู้ใช้ต้องรับผิดชอบต่อการนำไปใช้งานและการปรับแต่งระบบเอง

## แนวทางการปรับปรุงสำหรับการใช้งานจริง

หากต้องการนำไปใช้งานจริง ควรพิจารณาปรับปรุงในประเด็นต่อไปนี้:

1. **ความปลอดภัย**:
   - เพิ่มการป้องกัน CSRF ที่สมบูรณ์
   - ใช้ HTTPS
   - เพิ่มการป้องกัน Brute Force Attack
   - เข้ารหัสข้อมูลที่สำคัญในฐานข้อมูล

2. **ประสิทธิภาพ**:
   - เพิ่ม Index ในฐานข้อมูล
   - ใช้ Caching
   - ลดการเรียกใช้ API ที่ไม่จำเป็น

3. **ฟีเจอร์เพิ่มเติม**:
   - ระบบจัดการสมาชิก/ลูกค้า
   - ระบบจัดการซัพพลายเออร์
   - ระบบสั่งซื้อสินค้า
   - ระบบโปรโมชั่นที่ซับซ้อนขึ้น
   - การเชื่อมต่อกับอุปกรณ์ฮาร์ดแวร์ (เครื่องสแกนบาร์โค้ด, เครื่องพิมพ์ใบเสร็จ)

4. **การทดสอบ**:
   - เพิ่มชุดการทดสอบอัตโนมัติ
   - ทดสอบความปลอดภัยอย่างเต็มรูปแบบ
   - ทดสอบการทำงานภายใต้โหลดสูง

## ข้อเสนอแนะจากการใช้ AI พัฒนาโปรเจค

โปรเจคนี้ถูกพัฒนาขึ้นโดยใช้ AI เป็นเครื่องมือหลักในการสร้างโค้ด ซึ่งพบข้อสังเกตและข้อเสนอแนะดังนี้:

1. **ข้อจำกัดของ API และ JavaScript**:
   - AI สามารถสร้าง RESTful API ได้ดี แต่มีข้อจำกัดในการจัดการข้อมูลแบบ real-time
   - การจัดการ State ใน Vanilla JavaScript ทำได้จำกัด ควรใช้ Framework เช่น React หรือ Vue.js สำหรับโปรเจคขนาดใหญ่

2. **รูปแบบ API ที่ AI สร้างได้**:
   - สร้าง Endpoint ตาม REST principles ได้ดี
   - จัดการ Authentication ผ่าน JWT ได้เหมาะสม
   - การตรวจสอบข้อมูลนำเข้ายังต้องปรับปรุง

3. **ความปลอดภัย**:
   - AI สามารถแนะนำแนวทางป้องกัน SQL Injection และ XSS ได้ดี
   - ยังขาดการจัดการความปลอดภัยที่ซับซ้อน เช่น rate limiting, CORS policy ที่เข้มงวด

4. **แนวทางการปรับปรุงการสั่งงาน AI**:
   - ระบุขอบเขตและโครงสร้างโปรเจคให้ชัดเจนตั้งแต่เริ่มต้น
   - แบ่งการพัฒนาเป็นส่วนย่อยๆ แทนการสร้างทั้งระบบในครั้งเดียว
   - ตรวจสอบและทดสอบโค้ดที่ได้จาก AI อย่างละเอียด
   - ให้ AI ออกแบบโครงสร้างระบบก่อนเริ่มเขียนโค้ด
   - ควรระบุมาตรฐานการเขียนโค้ดและความปลอดภัยที่ต้องการอย่างชัดเจน

## ผู้แต่ง
Goragod Wiriya
[https://kotchasan.com](https://kotchasan.com)
[https://github.com/goragodwiriya/pos-system](https://github.com/goragodwiriya/pos-system)
