<?php /* Simple PHP Blog */

require_once 'config.php';

// Sample blog posts data
$posts = [
    [
        'id' => 1,
        'title' => 'การเริ่มต้นเขียน PHP สำหรับมือใหม่',
        'content' => 'PHP เป็นภาษาโปรแกรมที่ได้รับความนิยมมากในการพัฒนาเว็บไซต์ เนื่องจากมีความยืดหยุ่นสูงและง่ายต่อการเรียนรู้...',
        'author' => 'สมชาย ใจดี',
        'created_at' => '2024-01-15 10:30:00',
        'views' => 1250,
        'category' => 'Programming'
    ],
    [
        'id' => 2,
        'title' => 'เทคนิคการเขียน SQL ให้มีประสิทธิภาพ',
        'content' => 'การเขียน SQL ที่ดีไม่ใช่แค่ให้ได้ผลลัพธ์ที่ต้องการ แต่ต้องคำนึงถึงประสิทธิภาพในการทำงานด้วย...',
        'author' => 'สมชาย ใจดี',
        'created_at' => '2024-01-10 14:20:00',
        'views' => 890,
        'category' => 'Database'
    ],
    [
        'id' => 3,
        'title' => 'การใช้ JavaScript ร่วมกับ PHP',
        'content' => 'การผสมผสานระหว่าง JavaScript และ PHP จะช่วยให้เราสร้างเว็บแอปพลิเคชันที่มีความสามารถสูง...',
        'author' => 'สมชาย ใจดี',
        'created_at' => '2024-01-05 09:15:00',
        'views' => 1450,
        'category' => 'Web Development'
    ]
];

// Get current page
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;
$per_page = 5;
$total_posts = count($posts);
$total_pages = ceil($total_posts / $per_page);

// Get posts for current page
$offset = ($page - 1) * $per_page;
$current_posts = array_slice($posts, $offset, $per_page);

// Get single post if ID is provided
$single_post = null;
if (isset($_GET['id'])) {
    $post_id = (int) $_GET['id'];
    foreach ($posts as $post) {
        if ($post['id'] == $post_id) {
            $single_post = $post;
            break;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="th">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?=$single_post ? htmlspecialchars($single_post['title']).' - ' : '';?>PHP Blog System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background: #f8f9fa;
        }

        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }

        header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 2rem 0;
            text-align: center;
        }

        header h1 {
            font-size: 2.5rem;
            margin-bottom: 0.5rem;
        }

        header p {
            font-size: 1.1rem;
            opacity: 0.9;
        }

        nav {
            background: white;
            padding: 1rem 0;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 2rem;
        }

        nav ul {
            list-style: none;
            display: flex;
            justify-content: center;
            gap: 2rem;
        }

        nav a {
            text-decoration: none;
            color: #333;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 4px;
            transition: all 0.3s;
        }

        nav a:hover {
            background: #667eea;
            color: white;
        }

        .main-content {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 2rem;
            margin-bottom: 2rem;
        }

        .posts-section {
            background: white;
            border-radius: 8px;
            padding: 2rem;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .sidebar {
            background: white;
            border-radius: 8px;
            padding: 2rem;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            height: fit-content;
        }

        .post {
            border-bottom: 1px solid #eee;
            padding-bottom: 2rem;
            margin-bottom: 2rem;
        }

        .post:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }

        .post h2 {
            color: #333;
            margin-bottom: 1rem;
            font-size: 1.5rem;
        }

        .post h2 a {
            color: inherit;
            text-decoration: none;
        }

        .post h2 a:hover {
            color: #667eea;
        }

        .post-meta {
            color: #666;
            font-size: 0.9rem;
            margin-bottom: 1rem;
            display: flex;
            gap: 1rem;
            flex-wrap: wrap;
        }

        .post-meta span {
            display: flex;
            align-items: center;
            gap: 0.3rem;
        }

        .post-content {
            color: #555;
            line-height: 1.7;
        }

        .read-more {
            display: inline-block;
            margin-top: 1rem;
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
        }

        .read-more:hover {
            text-decoration: underline;
        }

        .pagination {
            text-align: center;
            margin-top: 2rem;
        }

        .pagination a {
            display: inline-block;
            padding: 0.5rem 1rem;
            margin: 0 0.25rem;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 4px;
        }

        .pagination a:hover {
            background: #5a67d8;
        }

        .pagination .current {
            background: #4c51bf;
        }

        .widget {
            margin-bottom: 2rem;
        }

        .widget h3 {
            color: #333;
            margin-bottom: 1rem;
            padding-bottom: 0.5rem;
            border-bottom: 2px solid #667eea;
        }

        .widget ul {
            list-style: none;
        }

        .widget li {
            padding: 0.5rem 0;
            border-bottom: 1px solid #eee;
        }

        .widget a {
            color: #555;
            text-decoration: none;
        }

        .widget a:hover {
            color: #667eea;
        }

        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .stat-box {
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: white;
            padding: 1.5rem;
            border-radius: 8px;
            text-align: center;
        }

        .stat-number {
            font-size: 2rem;
            font-weight: bold;
            display: block;
        }

        .stat-label {
            font-size: 0.9rem;
            opacity: 0.9;
        }

        footer {
            background: #333;
            color: white;
            text-align: center;
            padding: 2rem 0;
            margin-top: 2rem;
        }

        @media (max-width: 768px) {
            .main-content {
                grid-template-columns: 1fr;
            }

            .stats {
                grid-template-columns: repeat(2, 1fr);
            }

            nav ul {
                flex-direction: column;
                gap: 0.5rem;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <h1>🚀 PHP Blog System</h1>
            <p>ระบบบล็อกที่พัฒนาด้วย PHP และ MySQL</p>
        </div>
    </header>

    <nav>
        <div class="container">
            <ul>
                <li><a href="?">หน้าแรก</a></li>
                <li><a href="?category=programming">Programming</a></li>
                <li><a href="?category=database">Database</a></li>
                <li><a href="?category=web-development">Web Development</a></li>
                <li><a href="?about">เกี่ยวกับ</a></li>
            </ul>
        </div>
    </nav>

    <div class="container">
        <!-- Statistics -->
        <div class="stats">
            <div class="stat-box">
                <span class="stat-number"><?=count($posts);?></span>
                <span class="stat-label">บทความทั้งหมด</span>
            </div>
            <div class="stat-box">
                <span class="stat-number"><?=array_sum(array_column($posts, 'views'));?></span>
                <span class="stat-label">ยอดเข้าชม</span>
            </div>
            <div class="stat-box">
                <span class="stat-number">3</span>
                <span class="stat-label">หมวดหมู่</span>
            </div>
            <div class="stat-box">
                <span class="stat-number">1</span>
                <span class="stat-label">ผู้เขียน</span>
            </div>
        </div>

        <div class="main-content">
            <main class="posts-section">
                <?php if ($single_post): ?>
                    <!-- Single Post View -->
                    <article class="post">
                        <h1><?=htmlspecialchars($single_post['title']);?></h1>
                        <div class="post-meta">
                            <span>👤 <?=htmlspecialchars($single_post['author']);?></span>
                            <span>📅 <?=date('d/m/Y H:i', strtotime($single_post['created_at']));?></span>
                            <span>👁️ <?=number_format($single_post['views']);?> ครั้ง</span>
                            <span>🏷️ <?=htmlspecialchars($single_post['category']);?></span>
                        </div>
                        <div class="post-content">
                            <p><?=htmlspecialchars($single_post['content']);?></p>
                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>
                            <p>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>
                            <h3>ตัวอย่างโค้ด PHP</h3>
                            <pre style="background: #f4f4f4; padding: 1rem; border-radius: 4px; overflow-x: auto;"><code>&lt;?php
class BlogPost {
    private $title;
    private $content;
    private $author;

    public function __construct($title, $content, $author) {
        $this->title = $title;
        $this->content = $content;
        $this->author = $author;
    }

    public function getTitle() {
        return $this->title;
    }

    public function display() {
        echo "&lt;h2&gt;" . htmlspecialchars($this->title) . "&lt;/h2&gt;";
        echo "&lt;p&gt;" . htmlspecialchars($this->content) . "&lt;/p&gt;";
        echo "&lt;small&gt;โดย: " . htmlspecialchars($this->author) . "&lt;/small&gt;";
    }
}

// การใช้งาน
$post = new BlogPost(
    "หัวข้อบทความ",
    "เนื้อหาบทความ...",
    "ชื่อผู้เขียน"
);
$post->display();
?&gt;</code></pre>
                        </div>
                    </article>
                    <a href="?" style="display: inline-block; margin-top: 1rem; color: #667eea;">← กลับไปหน้าแรก</a>
                <?php else: ?>
                    <!-- Posts List View -->
                    <h2>บทความล่าสุด</h2>
                    <?php foreach ($current_posts as $post): ?>
                        <article class="post">
                            <h2><a href="?id=<?=$post['id'];?>"><?=htmlspecialchars($post['title']);?></a></h2>
                            <div class="post-meta">
                                <span>👤 <?=htmlspecialchars($post['author']);?></span>
                                <span>📅 <?=date('d/m/Y', strtotime($post['created_at']));?></span>
                                <span>👁️ <?=number_format($post['views']);?> ครั้ง</span>
                                <span>🏷️ <?=htmlspecialchars($post['category']);?></span>
                            </div>
                            <div class="post-content">
                                <p><?=htmlspecialchars($post['content']);?></p>
                            </div>
                            <a href="?id=<?=$post['id'];?>" class="read-more">อ่านต่อ →</a>
                        </article>
                    <?php endforeach; ?>

                    <!-- Pagination -->
                    <?php if ($total_pages > 1): ?>
                        <div class="pagination">
                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                <a href="?page=<?=$i;?>" class="<?=$i == $page ? 'current' : '';?>"><?=$i;?></a>
                            <?php endfor; ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </main>

            <aside class="sidebar">
                <div class="widget">
                    <h3>🔥 บทความยอดนิยม</h3>
                    <ul>
                        <?php
$popular_posts = $posts;
usort($popular_posts, function ($a, $b) {
    return $b['views'] - $a['views'];
});
foreach (array_slice($popular_posts, 0, 3) as $post):
?>
                            <li><a href="?id=<?=$post['id'];?>"><?=htmlspecialchars($post['title']);?></a></li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <div class="widget">
                    <h3>📂 หมวดหมู่</h3>
                    <ul>
                        <?php
$categories = array_unique(array_column($posts, 'category'));
foreach ($categories as $category):
?>
                            <li><a href="?category=<?=strtolower(str_replace(' ', '-', $category));?>"><?=htmlspecialchars($category);?></a></li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <div class="widget">
                    <h3>📊 สถิติเว็บไซต์</h3>
                    <ul>
                        <li>บทความทั้งหมด: <?=count($posts);?> บทความ</li>
                        <li>ยอดเข้าชมรวม: <?=number_format(array_sum(array_column($posts, 'views')));?> ครั้ง</li>
                        <li>อัปเดตล่าสุด: <?=date('d/m/Y');?></li>
                    </ul>
                </div>

                <div class="widget">
                    <h3>🔗 ลิงก์ที่เป็นประโยชน์</h3>
                    <ul>
                        <li><a href="https://php.net" target="_blank">PHP.net</a></li>
                        <li><a href="https://dev.mysql.com" target="_blank">MySQL</a></li>
                        <li><a href="https://developer.mozilla.org" target="_blank">MDN Web Docs</a></li>
                        <li><a href="https://github.com" target="_blank">GitHub</a></li>
                    </ul>
                </div>
            </aside>
        </div>
    </div>

    <footer>
        <div class="container">
            <p>&copy; 2024 PHP Blog System. สร้างด้วย ❤️ โดย สมชาย ใจดี</p>
            <p>ระบบบล็อกตัวอย่างที่พัฒนาด้วย PHP, HTML, CSS และ JavaScript</p>
        </div>
    </footer>

    <script>
        // Simple search functionality
        function searchPosts() {
            const searchTerm = document.getElementById('search').value.toLowerCase();
            const posts = document.querySelectorAll('.post');

            posts.forEach(post => {
                const title = post.querySelector('h2').textContent.toLowerCase();
                const content = post.querySelector('.post-content').textContent.toLowerCase();

                if (title.includes(searchTerm) || content.includes(searchTerm)) {
                    post.style.display = 'block';
                } else {
                    post.style.display = 'none';
                }
            });
        }

        // Smooth scrolling
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                document.querySelector(this.getAttribute('href')).scrollIntoView({
                    behavior: 'smooth'
                });
            });
        });

        // PHP Blog System loaded successfully
    </script>
</body>
</html>
