# Now.js - HTML Template

⚡ HTML Template สำหรับเว็บไซต์ JavaScript Framework ที่ทันสมัยและสวยงาม

## 📋 คำอธิบายโปรเจ็ค

โปรเจ็คนี้เป็น **HTML Template** สำหรับสร้างเว็บไซต์แนะนำ JavaScript Framework แบบ Landing Page ที่มีดีไซน์ทันสมัย รองรับการใช้งานบนทุกอุปกรณ์ และมีฟีเจอร์ที่หลากหลาย

Template นี้ออกแบบมาเพื่อแสดงคุณสมบัติของ Framework, ตัวอย่างโค้ด, คู่มือการเริ่มต้นใช้งาน และช่องทางการติดต่อชุมชน เหมาะสำหรับนำไปปรับใช้กับโปรเจ็ค Open Source, Framework, Library หรือเครื่องมือสำหรับนักพัฒนา

## ✨ คุณสมบัติเด่น

### 🎨 การออกแบบ
- **Modern UI/UX** - ดีไซน์ทันสมัยด้วย Gradient สีสันสวยงาม
- **Responsive Design** - รองรับทุกขนาดหน้าจอ (Desktop, Tablet, Mobile)
- **Smooth Animations** - แอนิเมชันลื่นไหลด้วย CSS และ JavaScript
- **Glassmorphism Effects** - เอฟเฟกต์แก้วฝ้าที่ทันสมัย
- **Gradient Backgrounds** - พื้นหลังไล่สีที่สวยงาม

### 🚀 ฟีเจอร์หลัก
- **Hero Section** - ส่วนหัวที่โดดเด่นพร้อมแอนิเมชันพิมพ์โค้ด
- **Features Grid** - แสดงคุณสมบัติเด่นแบบ Card Layout
- **Code Examples** - ระบบแท็บสำหรับแสดงตัวอย่างโค้ด
- **Getting Started Guide** - คู่มือเริ่มต้นใช้งานแบบ Step-by-step
- **Community Section** - ส่วนแสดงช่องทางติดต่อชุมชน
- **Newsletter Form** - ฟอร์มสมัครรับข่าวสาร
- **Back to Top Button** - ปุ่มกลับขึ้นด้านบน

### 💻 เทคโนโลยีที่ใช้
- **HTML5** - โครงสร้างเว็บไซต์
- **CSS3** - การจัดรูปแบบและแอนิเมชัน
- **Vanilla JavaScript** - ฟังก์ชันการทำงานต่างๆ
- **Google Fonts (Inter)** - ฟอนต์ที่สวยงามและอ่านง่าย

### 🎯 JavaScript Features
- Typing Animation สำหรับโค้ดตัวอย่าง
- Counter Animation สำหรับสถิติ
- Smooth Scrolling Navigation
- Tab System สำหรับตัวอย่างโค้ด
- Intersection Observer สำหรับ Scroll Animations
- Copy to Clipboard สำหรับโค้ดบล็อก
- Mobile Menu Toggle
- Dark Mode Support (พร้อมใช้งาน)
- Lazy Loading สำหรับรูปภาพ
- Performance Monitoring

## 📁 โครงสร้างไฟล์

```
now-template/
├── index.html          # ไฟล์ HTML หลัก
├── style.css           # ไฟล์ CSS สำหรับการจัดรูปแบบ
├── script.js           # ไฟล์ JavaScript สำหรับฟังก์ชันต่างๆ
├── LICENSE             # ไฟล์ลิขสิทธิ์ (MIT License)
├── README.md           # ไฟล์นี้
└── .gitignore          # ไฟล์สำหรับ Git ignore
```

## 🚀 การติดตั้งและใช้งาน

### วิธีที่ 1: ใช้งานโดยตรง
1. ดาวน์โหลด โปรเจ็ค

2. เปิดไฟล์ `index.html` ด้วย Web Browser
```bash
cd now-template
open index.html  # macOS
start index.html # Windows
xdg-open index.html # Linux
```

### วิธีที่ 2: ใช้งานกับ Local Server
```bash
# ใช้ Python
python -m http.server 8000

# ใช้ PHP
php -S localhost:8000

# ใช้ Node.js (ต้องติดตั้ง http-server ก่อน)
npx http-server -p 8000
```

จากนั้นเปิดเบราว์เซอร์ไปที่ `http://localhost:8000`

## 🎨 การปรับแต่ง

### เปลี่ยนสีธีม
แก้ไขค่าสีใน `style.css`:
```css
/* Primary Gradient */
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);

/* เปลี่ยนเป็นสีที่คุณต้องการ */
background: linear-gradient(135deg, #FF6B6B 0%, #4ECDC4 100%);
```

### เปลี่ยนฟอนต์
แก้ไขใน `index.html` (ส่วน `<head>`):
```html
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
```

และใน `style.css`:
```css
body {
  font-family: 'Poppins', sans-serif;
}
```

### ปรับแต่งเนื้อหา
- แก้ไขข้อความใน `index.html`
- เปลี่ยนโค้ดตัวอย่างในส่วน Examples
- ปรับแต่งลิงก์ Social Media และ Community

### เพิ่ม/ลดฟีเจอร์
- เพิ่ม Feature Card ในส่วน Features
- เพิ่มแท็บใหม่ในส่วน Code Examples
- ปรับแต่งขั้นตอนใน Getting Started

## 📱 Responsive Breakpoints

Template รองรับ Responsive Design ที่ Breakpoints ต่อไปนี้:

- **Desktop**: > 1024px
- **Tablet**: 768px - 1024px
- **Mobile**: < 768px
- **Small Mobile**: < 480px

## 🎯 ส่วนประกอบหลัก

### 1. Navigation Bar
- Fixed Navigation พร้อม Blur Effect
- Smooth Scroll เมื่อคลิกลิงก์
- Mobile Menu Toggle
- Active Link Highlighting

### 2. Hero Section
- Animated Background Grid
- Typing Animation สำหรับโค้ด
- Counter Animation สำหรับสถิติ
- CTA Buttons
- 3D Transform Effect บน Code Window

### 3. Features Section
- Grid Layout แบบ Responsive
- Hover Effects
- Icon + Title + Description
- Gradient Border Animation

### 4. Code Examples Section
- Tab System สำหรับสลับตัวอย่าง
- Syntax Highlighting
- Code Window Design
- Responsive Layout

### 5. Getting Started Section
- Step-by-step Guide
- Copy to Clipboard สำหรับคำสั่ง
- Numbered Steps
- Code Blocks

### 6. Community Section
- Gradient Background
- Card Links ไปยัง Platform ต่างๆ
- Hover Effects
- Icon + Title + Description

### 7. Newsletter Section
- Email Input Form
- Form Validation
- Success/Error Messages
- Responsive Layout

### 8. Footer
- Multi-column Layout
- Links Section
- Social Media Icons
- Copyright Information

## 🔧 JavaScript Functions

### Core Class: `NowJSWebsite`
```javascript
// ฟังก์ชันหลักๆ ที่มีให้ใช้งาน
- initTypingAnimation()      // แอนิเมชันพิมพ์โค้ด
- initCounterAnimation()      // แอนิเมชันนับเลข
- initTabSystem()             // ระบบแท็บ
- initCopyButtons()           // ปุ่มคัดลอกโค้ด
- initSmoothScroll()          // Smooth Scrolling
- initIntersectionObserver()  // Scroll Animations
- initDarkMode()              // Dark Mode
- initLazyLoading()           // Lazy Load Images
```

## 🎨 CSS Features

- **CSS Variables** - พร้อมใช้งาน (สามารถเพิ่มได้)
- **Flexbox & Grid** - Layout ที่ยืดหยุ่น
- **CSS Animations** - แอนิเมชันที่ลื่นไหล
- **Transitions** - การเปลี่ยนแปลงที่นุ่มนวล
- **Media Queries** - Responsive Design
- **Pseudo Elements** - เอฟเฟกต์พิเศษ

## 🌐 Browser Support

Template รองรับเบราว์เซอร์สมัยใหม่:

- ✅ Chrome (แนะนำ)
- ✅ Firefox
- ✅ Safari
- ✅ Edge
- ✅ Opera

## 📄 License

โปรเจ็คนี้เผยแพร่ภายใต้ **MIT License** - ดูรายละเอียดได้ที่ไฟล์ [LICENSE](LICENSE)

คุณสามารถ:
- ✅ ใช้งานเชิงพาณิชย์
- ✅ แก้ไขและปรับแต่ง
- ✅ แจกจ่ายต่อ
- ✅ ใช้ในโปรเจ็คส่วนตัว

## 👨‍💻 ผู้พัฒนา

**Goragod Wiriya**

- GitHub: [@goragodwiriya](https://github.com/goragodwiriya)

## 🙏 Credits

- **Fonts**: [Google Fonts - Inter](https://fonts.google.com/specimen/Inter)
- **Icons**: Emoji Icons (Unicode)
- **Inspiration**: Modern Framework Websites

---

**สร้างด้วย ❤️ และ ☕**

*Template นี้เหมาะสำหรับ: Landing Pages, Framework Documentation, Library Showcase, Developer Tools, Open Source Projects*
