# NovaDash

โปรเจ็คนี้เป็นชุดหน้าสถิติงาน (static dashboard) แบบง่าย ประกอบด้วย HTML ไฟล์สำหรับตัวอย่างแดชบอร์ดและหน้าตัวอย่างการใช้งาน

## สภาพรวม

- ชื่อโปรเจ็ค: NovaDash
- ประเภท: Static HTML dashboard (ไม่มี backend)
- ไฟล์สำคัญ: `index.html`, `crm.html`, `ecommerce.html`

## โครงสร้างไฟล์ (โดยย่อ)

- `index.html` — หน้าเริ่มต้น/หน้าหลักของแดชบอร์ด
- `crm.html` — ตัวอย่างหน้าที่เกี่ยวกับข้อมูล CRM
- `ecommerce.html` — ตัวอย่างหน้าที่เกี่ยวกับข้อมูลอีคอมเมิร์ซ

> หากต้องการรายละเอียดเพิ่มเติมเกี่ยวกับแต่ละไฟล์ ให้เปิดไฟล์นั้นๆ ด้วยตัวแก้ไขข้อความหรือเบราว์เซอร์

## วิธีรันแบบง่าย (Local)

เพราะเป็น static site สามารถเปิด `index.html` โดยตรงในเบราว์เซอร์ได้เลย แต่วิธีที่แนะนำคือรันเว็บเซิร์ฟเวอร์แบบง่าย เพื่อให้เส้นทาง (paths) และ fetch (ถ้ามี) ทำงานถูกต้อง:

1) ใช้ Python (พร้อมอยู่ในเครื่อง Linux/macOS/Windows ที่ติดตั้ง Python)

```bash
# ในโฟลเดอร์โปรเจ็ค (ที่มี index.html)
python3 -m http.server 8000
# แล้วเปิด http://localhost:8000
```

2) หรือใช้ Node.js utility เช่น `serve` หากติดตั้งแล้ว

```bash
# ติดตั้งครั้งแรก
npm install -g serve
# รัน
serve -s . -l 5000
# แล้วเปิด http://localhost:5000
```

3) หรือเพียงดับเบิลคลิกที่ `index.html` เพื่อเปิดในเบราว์เซอร์ (จำกัดบางฟีเจอร์ เช่น fetch แบบ CORS)

## การปรับแต่ง

- แก้ไข HTML/CSS/JS ในไฟล์ที่เกี่ยวข้องเพื่อปรับหน้าตาหรือข้อมูล
- หากต้องการเชื่อมข้อมูลจริง ให้เพิ่ม backend หรือเรียก API ผ่าน JavaScript และระวังเรื่อง CORS

## การดีพลอย (แนะนำ)

- GitHub Pages: เหมาะสำหรับ static site — push repository ขึ้น GitHub แล้วเปิดใช้งาน GitHub Pages ใน settings
- Netlify / Vercel: รองรับการดีพลอย static site และมีตัวเลือกสำหรับ continuous deploy