# MVP Leave Bot

ระบบบอท Telegram สำหรับการจัดการการลา และ Work From Home พร้อมระบบลงทะเบียนใหม่ที่เรียบง่าย

## การตั้งค่าระบบลงทะเบียน

### ไฟล์คอนฟิก: `config/db_config.php`

```php
// การตั้งค่าการลงทะเบียน
define('ALLOW_SELF_REGISTRATION', true); // true = เปิดให้ลงทะเบียนด้วยตัวเอง, false = ใช้เฉพาะสมาชิกในฐานข้อมูล
define('DEFAULT_MANAGER_ID', 1); // ผู้จัดการเริ่มต้นสำหรับพนักงานใหม่ (ID ของ HR หรือ Manager)
define('AUTO_GENERATE_EMPLOYEE_CODE', true); // สร้างรหัสพนักงานอัตโนมัติ
define('EMPLOYEE_CODE_PREFIX', 'EMP'); // คำนำหน้ารหัสพนักงาน
```

## ระบบลงทะเบียนใหม่

### เมื่อ `ALLOW_SELF_REGISTRATION = true`
- ผู้ใช้สามารถลงทะเบียนด้วยตัวเองผ่านคำสั่ง `/register`
- ระบบจะขอข้อมูล: ชื่อจริง, นามสกุล, อีเมล
- ข้อมูลจะถูกบันทึกลงตาราง `employees` โดยตรง
- ค่าเริ่มต้น: `is_manager = 0`, `is_hr = 0`

### เมื่อ `ALLOW_SELF_REGISTRATION = false`
- การลงทะเบียนด้วยตัวเองถูกปิดใช้งาน
- เฉพาะผู้ใช้ที่มีข้อมูลในตาราง `employees` เท่านั้นที่สามารถใช้บอทได้
- ผู้ดูแลระบบต้องเพิ่มข้อมูลผู้ใช้ผ่าน SQL โดยตรง

## การใช้งาน

### คำสั่งหลัก
- `/start` - เริ่มการสนทนา
- `/register` - ลงทะเบียนเข้าใช้งานระบบ (เมื่อเปิดใช้งาน)
- `/status` - ตรวจสอบสถานะการลงทะเบียน
- `/help` - แสดงคำสั่งที่ใช้ได้

### คำสั่งสำหรับผู้ใช้ที่ลงทะเบียนแล้ว
- `/ลา` หรือ `/leave` - เริ่มขั้นตอนการขอลา
- `/wfh` - เริ่มขั้นตอนการขอ Work From Home
- `/เช็คยอด` หรือ `/balance` - ตรวจสอบยอดวันลาคงเหลือ
- `/ยกเลิกคำขอ` หรือ `/cancelrequest` - ยกเลิกคำขอที่รออนุมัติ
- `/สรุปวันนี้` หรือ `/whosout` - (HR) สรุปผู้ที่ไม่อยู่ในออฟฟิศวันนี้
- `/cancel` - ยกเลิกการดำเนินการปัจจุบัน

## กระบวนการลงทะเบียน

1. **เริ่มต้น**: ผู้ใช้พิมพ์ `/register`
2. **ชื่อจริง**: ระบบขอชื่อจริง (อย่างน้อย 2 ตัวอักษร)
3. **นามสกุล**: ระบบขอนามสกุล (อย่างน้อย 2 ตัวอักษร)
4. **อีเมล**: ระบบขออีเมล (ตรวจสอบรูปแบบและไม่ซ้ำในระบบ)
5. **ยืนยัน**: แสดงข้อมูลให้ยืนยัน (พิมพ์ "ถูกต้อง" หรือ "ยกเลิก")
6. **เสร็จสิ้น**: บันทึกข้อมูลลงฐานข้อมูลและแสดงข้อมูลสมาชิกใหม่

## ไฟล์ State การลงทะเบียน

- เก็บไว้ในโฟลเดอร์ `logs/`
- รูปแบบ: `registration_{userId}_{chatId}.json`
- หมดอายุใน 30 นาที
- ลบอัตโนมัติเมื่อเสร็จสิ้นหรือยกเลิก

## การติดตั้ง

1. **Database**: นำเข้า `leave_bot.sql` เพื่อสร้างตารางและข้อมูลตัวอย่าง
2. **Config**: แก้ไข `config/db_config.php` และ `config/telegram_config.php`
3. **Permissions**: ตรวจสอบว่าโฟลเดอร์ `logs/` สามารถเขียนได้
4. **Webhook**: ตั้งค่า webhook ไปที่ `webhook_handler.php` (ไฟล์หลัก)

## ตารางฐานข้อมูลหลัก

- **`employees`**: ข้อมูลพนักงาน
- **`leave_types`**: ประเภทการลา
- **`leave_requests`**: คำขอลา/WFH
- **`leave_balances`**: ยอดวันลาคงเหลือ

## การจัดการสิทธิ์

- **พนักงานทั่วไป**: `is_manager = 0`, `is_hr = 0`
- **ผู้จัดการ**: `is_manager = 1`, `is_hr = 0`
- **HR**: `is_manager = 1`, `is_hr = 1`

## ข้อมูลสำคัญ

- การลงทะเบียนทำผ่านการกรอกข้อมูลโดยตรงและบันทึกลงตาราง `employees`
- การตั้งค่าทั้งหมดอยู่ในไฟล์ PHP config แทนการเก็บในฐานข้อมูล
- ระบบง่ายขึ้น ลดขั้นตอน และเหมาะสำหรับการใช้งานจริง
- **ไฟล์หลักถูกย้ายออกจาก `public/` มาที่ root directory เพื่อความสะดวกในการจัดการ**


## Structure
```
├── config/
│   ├── db_config.php       # Database configuration + Registration settings
│   └── telegram_config.php # Telegram bot token
├── src/
│   ├── Core/
│   │   └── Database.php   # Database connection class
│   ├── Handlers/
│   │   ├── LeaveApplicationHandler.php
│   │   ├── BalanceCheckHandler.php
│   │   ├── CancelRequestHandler.php
│   │   ├── ManagerActionHandler.php
│   │   ├── HrSummaryHandler.php
│   │   └── SelfRegistrationHandler.php  # NEW: Self registration
│   ├── Models/
│   │   ├── Employee.php
│   │   ├── LeaveRequest.php
│   │   ├── LeaveBalance.php
│   │   └── LeaveType.php
│   └── Services/
│       └── TelegramService.php
├── assets/                 # CSS, JS, images (if needed)
├── logs/                   # Registration state files & webhook logs
├── index.php               # Optional web interface
├── webhook_handler.php     # Main webhook handler (MOVED from public/)
└── leave_bot.sql          # Database schema (simplified)
```
