# Mobile Store (static PWA)

สรุป
- เว็บหน้าร้านมือถือขนาดเล็ก เป็น static site (HTML/CSS/JS) ที่ออกแบบให้ทันสมัย โทนสีฟ้า ใช้ฟอนต์ไทย "Prompt" จาก Google Fonts
- PWA พร้อม service worker, `manifest.json` และหน้า `offline.html`
- รูปภาพสินค้าเก็บเป็น WebP ภายในโฟลเดอร์ `images/`
- ข้อมูลสินค้าเป็นไฟล์ API-like `products.json`
- ตะกร้าสินค้าบันทึกใน localStorage (key: `blue_mobile_cart_v1`)

คุณสมบัติเด่น
- ธีมสีน้ำเงินและฟอนต์ Prompt
- PWA: ติดตั้ง, ออฟไลน์ fallback via `sw.js`
- ประสิทธิภาพ: ภาพ WebP, lazy-loading, responsive `<picture>` / srcset
- Accessibility: `aria-labels`, ลำดับหัวเรื่องที่ถูกต้อง, meta description, OG tags
- การเก็บตะกร้าแบบถาวรด้วย `localStorage`

โครงสร้างไฟล์หลัก
- `index.html` — หน้าเว็บหลัก
- `styles.css` — สไตล์ของโปรเจ็ค
- `app.js` — โลจิกโหลดสินค้า แสดงรายการ ตะกร้า และลงทะเบียน service worker
- `products.json` — ข้อมูลสินค้าในรูปแบบ API-like
- `manifest.json` — PWA manifest
- `sw.js` — service worker (caching strategies)
- `offline.html` — หน้า fallback เมื่อออฟไลน์
- `images/` — รูปภาพสินค้า (WebP)
- `icons/` — ไอคอนแอป (PNG/SVG)

การติดตั้งและรัน (ทดสอบแบบ local)
1. เปิด terminal ที่โฟลเดอร์โปรเจ็ค
2. รันเซิร์ฟเวอร์ไฟล์แบบง่าย (จำเป็นสำหรับ service worker ใช้งานบน localhost/HTTPS)

```bash
python3 -m http.server 8000
```

3. เปิดเบราว์เซอร์ที่ `http://localhost:8000`

หมายเหตุ: Service Worker จะลงทะเบียนได้เฉพาะบน `http://localhost` หรือ HTTPS.

การพัฒนา & แก้ไขรูปภาพ
- รูปภาพถูกเก็บเป็น WebP ใน `images/` (เช่น `images/product-1-400.webp`, `images/product-1-800.webp`, `images/hero-1-1200.webp`)
- หากต้องการสร้างภาพใหม่ ใส่ URL ต้นฉบับลงไฟล์สคริปต์หรือ `products.json`


การตั้งค่า PWA / Cache
- ไอคอนและ `manifest.json` ถูกเตรียมไว้แล้ว
- `sw.js` ใช้กลยุทธ์ cache-first สำหรับ static assets และ network-first สำหรับ `products.json` (API)
- หากเพิ่มไฟล์สแตติกใหม่ ให้พิจารณาเพิ่มในรายการ cache หรือให้ SW จัดการ runtime caching

การเก็บตะกร้า
- localStorage key: `blue_mobile_cart_v1`
- ข้อมูลเป็น JSON; ถ้าต้องการย้ายไป IndexedDB สำหรับข้อมูลใหญ่ ให้เพิ่ม layer persistence ใหม่

ข้อสังเกตด้าน Accessibility & SEO
- มี meta description และ Open Graph tags เบื้องต้น
- ปุ่ม/ลิงก์ที่เป็นไอคอนมี `aria-label`
- มี visually-hidden H1 สำหรับโครงสร้างหัวเรื่องที่ถูกต้อง (เพิ่ม class `.visually-hidden` ใน `styles.css` ถ้าจำเป็น)

ผู้แต่ง
- Goragod Wiriya
- AI: GPT-5 mini (ช่วยออกแบบ/สร้าง/แก้ไข)

---

## Prompt สำหรับสร้างโปรเจ็คนี้ใหม่ (English)

Use the following prompt to reproduce the project from scratch. Be explicit about files, behavior, and assets.

Prompt (English)
---
Create a static e-commerce demo called "Mobile Store" with the following requirements:

1. Project basics
- Static site: HTML, CSS, vanilla JavaScript (no frameworks).
- Use Bootstrap 5 (CDN) for layout and Bootstrap Icons (CDN).
- Use Google Fonts: "Prompt" (Thai-friendly).
- Theme: modern blue palette.

2. Pages / Files to create
- `index.html`: main storefront with hero carousel and product grid.
- `styles.css`: theme variables + responsive styles and a `.visually-hidden` utility.
- `app.js`: load products from `products.json`, render product cards using `<picture>` with WebP `source` and `<img>` fallback (use WebP-first), implement cart (add/update/remove) and persist cart in localStorage under `blue_mobile_cart_v1`. Register service worker (`sw.js`).
- `products.json`: API-like response: e.g. { "status": "ok", "data": { "products": [ ... ], "total": N } } and each product includes `id`, `name`, `price`, `description`, `image` (local base path like `images/product-1`).
- `manifest.json`: PWA manifest with icons.
- `sw.js`: Service worker to cache static assets (cache-first) and `products.json` (network-first), with navigation fallback to `offline.html`.
- `offline.html`: minimal offline page.

3. Images and icons
- Store product and hero images as WebP in `images/` (sizes e.g., product-1-400.webp and product-1-800.webp; hero images 1200px).
- Provide `icons/` with PNG sizes used by `manifest.json`.
- Provide a simple script `scripts/download_images.sh` that can download remote images and convert to WebP using ImageMagick and cwebp (with graceful fallback).

4. Accessibility & SEO
- Add meta description and Open Graph tags in `index.html`.
- Ensure icon-only buttons/links have `aria-label`.
- Ensure headings are semantically correct (visible H2 for hero, hidden H1 for page-level title).

5. Performance & UX
- Use `<picture>` with WebP `source` and `img` using WebP `src` (no .jpg references).
- Lazy-load images (`loading="lazy"`).
- Cart persisted in `localStorage`.
- Service worker registered on load; manifest linked.

6. Deliverables
- All files listed above.
- A single README.md (Thai or English) that documents how to run locally (`python3 -m http.server 8000`), how the image pipeline works, and the localStorage key for the cart.
- Author metadata: Goragod Wiriya and AI GPT-5 mini.

Constraints & notes
- The site must run from `localhost` (service worker) or HTTPS.
- Prefer WebP and avoid keeping or referencing `.jpg` files in app code.
- Keep code minimal and readable. Add comments where helpful.

End of Prompt
---


*Generated: by Goragod Wiriya + AI GPT-5 mini*
