# Style Control Prompts for Dashboard Design

## 🎨 Visual Design Style Prompts

### **Color Palette Control**
```css
Apply gradient color scheme:
- Primary cards: Blue-purple (#667eea → #764ba2), Pink-red (#f093fb → #f5576c), Cyan-blue (#4facfe → #00f2fe), Green-mint (#43e97b → #38f9d7)
- Background: Multi-layer blue gradients with pastel transitions
- Shadows: Color-matched to card gradients with 0.3-0.4 opacity
- Text: Dark charcoal (#212121) with gradient text effects on numbers
```

### **Typography & Spacing**
```css
Font system:
- Primary: 'Noto Sans Thai', sans-serif for full Thai language support
- Weights: 300 (light), 400 (regular), 500 (medium), 600 (semi-bold), 700 (bold)
- Scale: 12px (caption) → 14px (body) → 16px (subtitle) → 20px (title) → 24px (heading) → 36px (display)
- Spacing: 8px base unit system (8, 16, 24, 32, 48px)
```

### **Material Design Elevation**
```css
Shadow system:
- Level 1: 0 2px 1px -1px rgba(0,0,0,0.2), 0 1px 1px 0 rgba(0,0,0,0.14), 0 1px 3px 0 rgba(0,0,0,0.12)
- Level 4: 0 2px 4px -1px rgba(0,0,0,0.2), 0 4px 5px 0 rgba(0,0,0,0.14), 0 1px 10px 0 rgba(0,0,0,0.12)
- Level 8: 0 5px 5px -3px rgba(0,0,0,0.2), 0 8px 10px 1px rgba(0,0,0,0.14), 0 3px 14px 2px rgba(0,0,0,0.12)
- Custom: Color-tinted shadows matching card gradients
```

## 🔄 Animation & Interaction Styles

### **Hover & Focus Effects**
```css
Interaction patterns:
- Cards: transform: translateY(-8px) scale(1.02) on hover
- Buttons: Material ripple effect with 600ms linear animation
- Icons: subtle rotation (5-10deg) or scale(1.1) transforms
- Timing: cubic-bezier(0.4, 0, 0.2, 1) for Material motion
- Duration: 200-300ms for micro-interactions, 600ms for significant changes
```

### **Transition Specifications**
```css
Animation system:
- Page transitions: opacity + translateY(20px) transforms
- Staggered loading: 100ms delay between elements
- Smooth curves: cubic-bezier easing functions
- Performance: transform and opacity only, avoid layout triggers
```

## 📐 Layout & Structure Styles

### **Grid & Spacing System**
```css
Layout specifications:
- Stats grid: repeat(auto-fit, minmax(280px, 1fr)) with 24px gaps
- Card padding: 28px internal spacing
- Border radius: 16px for modern appearance
- Container margins: 24px on desktop, 16px on mobile
```

### **Component Sizing**
```css
Element dimensions:
- Icons: 24px standard, 48px for stat card icons
- Avatars: 32px (header), 44px (activity list)
- Buttons: min-height 36px, padding 12px 24px
- Input fields: 56px height for Material spec compliance
```

## 🎭 Visual Effects & Treatments

### **Glassmorphism & Blur Effects**
```css
Modern glass effects:
- backdrop-filter: blur(10px) on cards and overlays
- background: rgba(255, 255, 255, 0.95) for semi-transparency
- border: 1px solid rgba(255, 255, 255, 0.2) for subtle definition
- Gradient overlays: linear-gradient with 0.03 opacity color tints
```

### **Gradient Treatments**
```css
Gradient applications:
- Card backgrounds: Linear gradients with white base + colored tints
- Icons: Solid gradients with matching shadow colors
- Text effects: Background-clip text for premium number displays
- Top borders: 4px height gradient strips on cards
```

## 📱 Responsive Behavior Styles

### **Breakpoint Adaptations**
```css
Device-specific styles:
- Mobile (<768px): Collapse sidebar to 72px, single column stats, reduced padding
- Tablet (768-1024px): Maintain layout with adjusted spacing
- Desktop (>1024px): Full layout with optimal spacing and hover states
```

### **Touch-Friendly Adjustments**
```css
Mobile optimizations:
- Minimum touch targets: 44px x 44px
- Increased padding on interactive elements
- Simplified hover states for touch devices
- Gesture-friendly navigation patterns
```

## 🎨 Brand & Theme Styling

### **Color Psychology Application**
```css
Semantic color usage:
- Success/Growth: Green gradients (#43e97b → #38f9d7)
- Revenue/Money: Pink-red gradients (#f093fb → #f5576c)  
- Users/People: Blue-purple gradients (#667eea → #764ba2)
- Performance: Cyan-blue gradients (#4facfe → #00f2fe)
```

### **Consistency Rules**
```css
Design system rules:
- Icons always use Material Icons family
- Consistent 16px border-radius on smaller elements
- 8px baseline grid for all spacing decisions
- Color-coordinated shadows and highlights
- Progressive disclosure patterns for complex data
```

## 🔧 Implementation Style Guidelines

### **CSS Architecture**
```css
Code organization:
- CSS Custom Properties for themeable values
- Component-based class naming convention
- Utility classes for common patterns
- Progressive enhancement approach
- Mobile-first responsive design
```

### **Performance Optimizations**
```css
Rendering optimizations:
- Use transform3d() for hardware acceleration
- Avoid animating width/height properties
- Prefer opacity and transform for animations
- Implement will-change for heavy animations
- Optimize gradient complexity for mobile
```

---

## 💫 Quick Style Commands

### **Apply Modern Card Style:**
```
Style cards with: 16px border-radius, gradient backgrounds, color-matched shadows, 28px padding, backdrop-blur effects, and hover lift animations
```

### **Material Color System:**
```
Use Material Design color palette with custom gradients: blue-purple, pink-red, cyan-blue, green-mint themes with matching shadows and 0.03 opacity overlays
```

### **Typography Stack:**
```
Apply Noto Sans Thai font family with 300-700 weights, 8px baseline grid spacing, and gradient text effects on numeric displays
```

### **Animation Package:**
```
Implement Material motion with cubic-bezier easing, 200-300ms micro-interactions, ripple effects, and translateY hover states
```