<?php
require_once 'lottery_scraper.php';
header('Content-Type: application/json; charset=utf-8');

try {
    $scraper = new LotteryScraper();
    $data = $scraper->scrapeLotteryStats();

    // ตรวจสอบว่าฟังก์ชัน file_put_contents ใช้ได้หรือไม่
    if (function_exists('file_put_contents')) {
        $cacheFile = 'lottery_cache.json';
        $cacheData = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

        // ใช้ error suppression และตรวจสอบผลลัพธ์
        $writeResult = @file_put_contents($cacheFile, $cacheData);

        if ($writeResult === false) {
            // ถ้าเขียนไฟล์ไม่ได้ ให้แจ้งผลลัพธ์โดยไม่มี cache
            echo json_encode([
                'success' => true,
                'updated' => false,
                'message' => 'Data retrieved but cache disabled by hosting provider',
                'total' => isset($data['data']) ? count($data['data']) : 0,
                'data' => $data // ส่งข้อมูลกลับไปเลยแทนการ cache
            ]);
        } else {
            echo json_encode([
                'success' => true,
                'updated' => true,
                'total' => isset($data['data']) ? count($data['data']) : 0
            ]);
        }
    } else {
        // ฟังก์ชัน file_put_contents ถูกปิดใช้งาน
        echo json_encode([
            'success' => true,
            'updated' => false,
            'message' => 'File write functions disabled by hosting provider',
            'total' => isset($data['data']) ? count($data['data']) : 0,
            'data' => $data // ส่งข้อมูลกลับไปเลยแทนการ cache
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
