# 🚨 ReportMeme - ฟอร์มแจ้งความแบบมีมที่สนุกและเป็นมิตร 🚨

## 📋 คำอธิบายโปรเจ็ค

**ReportMeme** เป็นเว็บแอปพลิเคชันฟอร์มรับแจ้งความออนไลน์ที่มีสไตล์สนุกสนานและเป็นมิตรกับผู้ใช้ พัฒนาด้วยภาษา HTML, CSS และ JavaScript โดยไม่ต้องพึ่งพา Framework ภายนอก เหมาะสำหรับการใช้งานจริงหรือเป็นโปรเจ็คสาธิต

**ผู้พัฒนา:** Goragod Wiriya
**GitHub:** [github.com/goragodwiriya/reportmeme](https://github.com/goragodwiriya/reportmeme)

### ✨ จุดเด่นของโปรเจ็ค

- 🎨 **UI/UX ที่สวยงาม**: ใช้ Gradient สีสวย พร้อม Animation ที่น่าสนใจ
- 📱 **Responsive Design**: รองรับการใช้งานบนอุปกรณ์ทุกขนาด
- 🎭 **Meme Integration**: แสดงผล Meme ตลกหลังจากส่งฟอร์ม
- 📸 **ใบรับแจ้งความ**: สร้างและดาวน์โหลดใบรับแจ้งความได้
- 🇹🇭 **ภาษาไทย**: รองรับภาษาไทยเต็มรูปแบบ
- ⚡ **Pure Web Technologies**: ไม่ต้องติดตั้ง Dependencies เพิ่มเติม

## 🚀 การติดตั้งและรันโปรเจ็ค

### ข้อกำหนดของระบบ

- Web Browser ที่ทันสมัย (Chrome, Firefox, Safari, Edge)
- Web Server (เช่น Apache, Nginx, หรือ Python HTTP Server)

### วิธีการติดตั้ง

1. **Clone หรือดาวน์โหลดโปรเจ็ค**
   ```bash
   git clone https://github.com/goragodwiriya/reportmeme.git
   cd reportmeme
   ```

2. **รันด้วย Web Server**

   **วิธีที่ 1: ใช้ Python HTTP Server**
   ```bash
   python -m http.server 8000
   ```

   **วิธีที่ 2: ใช้ Node.js HTTP Server**
   ```bash
   npx http-server
   ```

   **วิธีที่ 3: ใช้ PHP Built-in Server**
   ```bash
   php -S localhost:8000
   ```

3. **เปิดในเบราว์เซอร์**
   ```
   http://localhost:8000
   ```

## 🎯 ฟีเจอร์หลัก

### 📝 ฟอร์มรับแจ้งความ

- **ข้อมูลผู้แจ้ง**: ชื่อ, เบอร์โทรศัพท์
- **รายละเอียดเหตุการณ์**: ประเภท, สถานที่, วันที่เกิดเหตุ
- **รายละเอียดเพิ่มเติม**: คำอธิบายเหตุการณ์, ข้อมูลผู้ต้องสงสัย

### 🎭 ระบบ Meme

- แสดง Meme พิเศษตามประเภทเหตุการณ์
- ข้อความสนุกสนานหลังส่งฟอร์ม
- หมายเลขคดีแบบสุ่ม

### 📊 ประเภทเหตุการณ์ที่รองรับ

| ประเภท | คำอธิบาย | Meme พิเศษ |
|--------|-----------|------------|
| 🦹‍♂️ ขโมย/ลักทรัพย์ | การขโมยหรือลักทรัพย์ | ✅ |
| 🚨 หลอกลวง | การหลอกลวงหรือฉ้อโกง | ✅ |
| 🚑 อุบัติเหตุ | อุบัติเหตุต่างๆ | ✅ |
| 😤 รบกวน/คุกคาม | การรบกวนหรือคุกคาม | ❌ |
| 👊 ถูกล้อเลียน/รังแก | การล้อเลียนหรือรังแก | ✅ |
| 🔊 เสียงดัง/รบกวนความสงบ | เสียงดังรบกวน | ❌ |
| 📋 อื่นๆ | เหตุการณ์อื่นๆ | ❌ |

### 🎨 การออกแบบ UI

- **สีหลัก**: Gradient สีน้ำเงิน-ม่วง (#667eea → #764ba2)
- **ฟอนต์**: Kanit, Mitr, Sarabun, Prompt (Google Fonts)
- **Animation**: Bounce effects, Hover animations, Loading spinner
- **Responsive**: รองรับหน้าจอ Mobile และ Desktop

### 📸 ระบบใบรับแจ้งความ

- สร้างใบรับแจ้งความแบบกราฟิก
- ใช้ HTML5 Canvas สร้างภาพ
- ดาวน์โหลดเป็นไฟล์ PNG
- มีข้อมูลผู้แจ้งแบบสุ่ม (เพื่อความปลอดภัย)

## 🛠️ โครงสร้างไฟล์

```
reportmeme/
├── index.html          # ไฟล์หลักของแอปพลิเคชัน
├── README.md          # ไฟล์คู่มือการใช้งาน (ไฟล์นี้)
└── screenshots/       # โฟลเดอร์รูปภาพตัวอย่าง (ถ้ามี)
```

## 💻 เทคโนโลยีที่ใช้

- **HTML5**: โครงสร้างหน้าเว็บ, Canvas API
- **CSS3**: Styling, Animations, Responsive Design
- **JavaScript (ES6+)**: Logic, Form Handling, Canvas Drawing
- **Google Fonts**: ฟอนต์ภาษาไทยที่สวยงาม

## 🎮 การใช้งาน

1. **เปิดเว็บไซต์** ในเบราว์เซอร์
2. **กรอกข้อมูล** ในฟอร์มรับแจ้งความ
   - ชื่อผู้แจ้ง
   - เบอร์โทรศัพท์
   - ประเภทเหตุการณ์
   - สถานที่เกิดเหตุ
   - วันที่และเวลาเกิดเหตุ
   - รายละเอียดเหตุการณ์
   - ข้อมูลผู้ต้องสงสัย (ถ้ามี)
3. **กดปุ่มส่ง** เพื่อส่งใบแจ้งความ
4. **รอดู Meme** และข้อความสนุกๆ
5. **ดาวน์โหลดใบรับแจ้งความ** (ถ้าต้องการ)

## 🔧 การปรับแต่ง

### เปลี่ยนสีธีม

แก้ไขในส่วน CSS:
```css
/* สีหลัก */
background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);

/* สีปุ่ม */
background: linear-gradient(135deg, #667eea, #764ba2);
```

### เพิ่ม Meme ใหม่

แก้ไขในไฟล์ JavaScript:
```javascript
const incidentMemes = {
  'newType': {
    image: "data:image/svg+xml,...", // SVG หรือ URL รูปภาพ
    text: "ข้อความที่ต้องการแสดง",
    caption: "คำอธิบายเพิ่มเติม"
  }
};
```

### เพิ่มประเภทเหตุการณ์

แก้ไขในส่วน HTML `<select>`:
```html
<option value="newType">ประเภทใหม่</option>
```

## 🐛 การแก้ไขปัญหา

### ปัญหาที่พบบ่อย

1. **ฟอนต์ไม่แสดงภาษาไทย**
   - ตรวจสอบการเชื่อมต่ออินเทอร์เน็ต (ใช้ Google Fonts)
   - ลองรีเฟรชหน้าเว็บ

2. **ใบรับแจ้งความไม่ดาวน์โหลด**
   - ตรวจสอบ Browser Settings สำหรับการดาวน์โหลดไฟล์
   - ลองใช้เบราว์เซอร์อื่น

3. **Animation ไม่ทำงาน**
   - ตรวจสอบว่าเบราว์เซอร์รองรับ CSS3 Animations
   - อัปเดตเบราว์เซอร์เป็นเวอร์ชันล่าสุด

## 📞 การติดต่อและสนับสนุน

หากมีปัญหาหรือข้อเสนอแนะ สามารถติดต่อได้ผ่าน:

- �‍💻 **ผู้พัฒนา:** Goragod Wiriya
- 🐙 **GitHub:** [github.com/goragodwiriya](https://github.com/goragodwiriya)

## 📄 ลิขสิทธิ์

โปรเจ็คนี้เป็น Open Source และสามารถนำไปใช้ได้อย่างเสรี
© 2568 Goragod Wiriya

---

## 🎉 ขอบคุณที่ใช้ ReportMeme!

**"ทำดีมีดี ทำชั่วมีชั่ว - แต่แจ้งความก่อนนะ!"** 😄

---

*README.md นี้สร้างขึ้นด้วย ❤️ โดย Goragod Wiriya เพื่อให้การใช้งานโปรเจ็คง่ายขึ้น*
