# 🏞️ Kanchanaburi Travel Guide Website

[![Made with ❤️](https://img.shields.io/badge/Made%20with-❤️-red.svg)](https://github.com/goragod)
[![AI Powered](https://img.shields.io/badge/AI%20Powered-Claude-blue.svg)](https://claude.ai)
[![WebP Optimized](https://img.shields.io/badge/Images-WebP%20Optimized-green.svg)](#)
[![Performance](https://img.shields.io/badge/Performance-Optimized-brightgreen.svg)](#)

> **เว็บไซต์ท่องเที่ยวกาญจนบุรี 1 วัน** - สร้างด้วย AI Claude และความรักในการท่องเที่ยวไทย

## 🌟 Overview

เว็บไซต์ท่องเที่ยวกาญจนบุรีแบบ Modern Single Page Application ที่ออกแบบมาเพื่อแนะนำสถานที่ท่องเที่ยวสำคัญในจังหวัดกาญจนบุรี พร้อมด้วยข้อมูลครบถ้วนและการออกแบบที่สวยงาม

### 🎯 Features

- **📱 Responsive Design** - รองรับทุกขนาดหน้าจอ
- **⚡ Performance Optimized** - โหลดเร็วด้วย WebP images และ render-blocking optimization
- **🎨 Modern UI/UX** - ใช้ CSS3 Effects, Animations, และ Glass Morphism
- **🖼️ Advanced Slideshow** - Fade transitions พร้อม 3D effects
- **💬 Interactive Modals** - ข้อมูลรายละเอียดแต่ละสถานที่
- **🔍 SEO Friendly** - Semantic HTML และ Meta tags

### 🏛️ สถานที่ท่องเที่ยวที่นำเสนอ

1. **🌉 สะพานข้ามแม่น้ำแคว** - แลนด์มาร์คประวัติศาสตร์ระดับโลก
2. **💧 น้ำตกเอราวัณ** - น้ำตก 7 ชั้นสีฟ้ามรกต
3. **🌳 ต้นจามจุรียักษ์** - ต้นไม้โบราณอายุ 100+ ปี
4. **🏗️ สกายวอล์คกาญจนบุรี** - ทางเดินกระจกใสริมแม่น้ำแคว

## 🚀 Technology Stack

### Frontend
- **HTML5** - Semantic markup พร้อม modern meta tags
- **CSS3** - Custom properties, Flexbox, Grid, Animations
- **JavaScript ES6+** - Modern DOM APIs, Intersection Observer
- **WebP Images** - Optimized image format (77% size reduction)

### Fonts & Icons
- **Prompt** - Google Fonts สำหรับ body text
- **Playfair Display** - Google Fonts สำหรับ headings
- **Font Awesome 6** - Icon library

### Performance
- **Critical CSS Inline** - Above-the-fold optimization
- **Async Resource Loading** - Non-blocking CSS/JS loading
- **Image Preloading** - Critical images preload
- **Font Display Swap** - Prevent invisible text flash

## 📁 Project Structure

```
kanchanaburi/
├── 📄 index.html          # Main HTML file
├── 🎨 style.css           # Complete CSS with 850+ lines
├── ⚡ script.js           # Interactive functionality
├── 📖 README.md           # Project documentation
├── 🎯 prompt.md           # AI prompt for recreation
└── 📁 images/             # Optimized images
    ├── bridge.webp        # สะพานข้ามแม่น้ำแคว
    ├── bridge.jpg         # JPG fallback
    ├── erawan.webp        # น้ำตกเอราวัณ
    ├── erawan.jpg         # JPG fallback
    ├── tree.webp          # ต้นจามจุรียักษ์
    ├── tree.jpg           # JPG fallback
    ├── skywalk.webp       # สกายวอล์ค
    └── skywalk.jpg        # JPG fallback
```

## 🎨 Design Features

### 🌈 Color Palette
```css
--primary-color: #00b8a9    /* Teal Green */
--secondary-color: #f8f3d3   /* Light Cream */
--accent-color: #f6416c      /* Pink Red */
--dark-color: #2c3333       /* Dark Gray */
--light-color: #f9f9f9      /* Light Gray */
```

### ✨ CSS Effects
- **Glass Morphism** - Backdrop blur effects
- **3D Transforms** - Slideshow container perspective
- **Gradient Animations** - Color shifting backgrounds
- **Hover Effects** - Scale, rotate, และ shadow
- **Fade Transitions** - Smooth content changes

### 🎭 Animations
- **Slideshow Effects** - Fade in/out with 3D rotation
- **Scroll Animations** - Intersection Observer triggered
- **Navigation Hover** - Floating button effects
- **Modal Transitions** - Slide in animations
- **Loading States** - Shimmer และ pulse effects

## ⚡ Performance Optimizations

### 🖼️ Image Optimization
- **WebP Format** - 77% smaller than JPEG
- **Consistent Sizing** - 1200x600px for all images
- **Picture Elements** - WebP with JPEG fallback
- **Lazy Loading** - Intersection Observer API

### 🚀 Loading Strategy
1. **Critical Resources** (0ms) - Inline CSS, system fonts
2. **Important Resources** (DOM Ready) - Main CSS, navigation JS
3. **Enhancement** (Load Event) - Font Awesome, full functionality

### 📊 Performance Gains
- **Render-blocking eliminated** - 280ms savings
- **Image size reduced** - 77% bandwidth savings
- **First Paint improved** - Critical CSS inline
- **Font loading optimized** - Display swap strategy

## 🛠️ Setup & Installation

### Quick Start
```bash
# Clone or download the project
git clone [repository-url]

# Navigate to project directory
cd kanchanaburi

# Open with live server
# Or simply open index.html in browser
```

### Development
```bash
# For local development with file watching
npx live-server

# Or use any local server
python -m http.server 8000
php -S localhost:8000
```

### Production Deployment
```bash
# Upload all files to web server
# Ensure WebP support is enabled
# Configure gzip compression for CSS/JS
# Set proper cache headers for images
```

## 🎯 Browser Support

### ✅ Fully Supported
- **Chrome 85+** - All features
- **Firefox 80+** - All features
- **Safari 14+** - All features
- **Edge 85+** - All features

### 📱 Mobile Support
- **iOS Safari 14+** - Full support
- **Android Chrome** - Full support
- **Mobile Firefox** - Full support

### 🔄 Fallbacks
- **WebP → JPEG** - Automatic fallback
- **Custom Fonts → System Fonts** - Font display swap
- **Modern CSS → Graceful degradation**

## 🤖 AI Development Process

### 🧠 Created with Claude AI
ตัวเว็บไซต์นี้ถูกสร้างขึ้นโดย **Goragod Wiriya** ด้วยการช่วยเหลือจาก **Claude AI** ผ่านกระบวนการ:

1. **Initial Request** - แยกไฟล์และดาวน์โหลดรูปภาพ
2. **Design Evolution** - ออกแบบใหม่ให้ทันสมัยและสวยงาม
3. **Performance Optimization** - ปรับปรุงความเร็วและประสิทธิภาพ
4. **Image Optimization** - แปลงเป็น WebP และปรับขนาด
5. **Render-blocking Fix** - แก้ไขปัญหาการโหลด CSS/JS
6. **Final Polish** - ปรับแต่งรายละเอียดและเอฟเฟกต์

### 🎨 Development Highlights
- **Modern Slideshow** - เปลี่ยนจาก slide เป็น fade effects
- **Performance First** - เน้นความเร็วในการโหลด
- **Thai Language Focus** - เนื้อหาและ UX เหมาะสำหรับคนไทย
- **Real Data** - ข้อมูลสถานที่ท่องเที่ยวจริง
- **Responsive Design** - ใช้งานได้ดีในทุกอุปกรณ์

## 📄 License & Credits

### 👨‍💻 Developer
- **Goragod Wiriya** - Main Developer
- **Claude AI** - AI Assistant & Code Generator

### 📸 Images
- Bridge image - River Kwai Bridge, Kanchanaburi
- Erawan image - Erawan National Park
- Tree image - Giant Chamchuri Tree
- Skywalk image - Kanchanaburi Skywalk

### 🔗 External Resources
- **Google Fonts** - Prompt & Playfair Display fonts
- **Font Awesome** - Icon library
- **DOMPurify** - XSS protection library

### 📜 License
```
MIT License

Copyright (c) 2025 Goragod Wiriya

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
```

---

## 🎉 Final Notes

เว็บไซต์นี้เป็นตัวอย่างของการใช้ AI ในการพัฒนาเว็บไซต์ที่มีคุณภาพสูง โดยเน้นที่ประสบการณ์ผู้ใช้ที่ดี ประสิทธิภาพในการโหลด และการออกแบบที่สวยงาม

**สร้างด้วยความรักสำหรับการท่องเที่ยวไทย** 🇹🇭

---

**Made with ❤️ by Goragod Wiriya & Claude AI**
