// กำหนดคีย์สำหรับ localStorage
const storageKey = 'kanbanData';

// โหลดข้อมูลจาก localStorage
window.onload = () => {
  loadBoard();
};

// เพิ่มการ์ดใหม่
function addCard(status) {
  const content = prompt('Enter task description:');
  if (!content) return;

  const cardData = {id: Date.now(), content: content, status: status};
  const data = getBoardData();
  data.push(cardData);
  saveBoardData(data);
  renderBoard();
}

// ลบการ์ด
function deleteCard(id) {
  const data = getBoardData().filter(card => card.id !== id);
  saveBoardData(data);
  renderBoard();
}

// โหลดข้อมูลจาก localStorage
function getBoardData() {
  return JSON.parse(localStorage.getItem(storageKey)) || [];
}

// บันทึกข้อมูลลง localStorage
function saveBoardData(data) {
  localStorage.setItem(storageKey, JSON.stringify(data));
}

// แสดงผลบอร์ด
function renderBoard() {
  const statuses = ['todo', 'in-progress', 'done'];
  statuses.forEach(status => {
    const container = document.getElementById(`${status}-cards`);
    container.innerHTML = '';
    getBoardData().filter(card => card.status === status).forEach(card => {
      const cardEl = document.createElement('div');
      cardEl.className = 'card';
      cardEl.draggable = true;
      cardEl.dataset.id = card.id;
      cardEl.innerHTML = `
        <p>${card.content}</p>
        <button onclick="deleteCard(${card.id})">Delete</button>
      `;
      cardEl.addEventListener('dragstart', dragStart);
      container.appendChild(cardEl);
    });
  });
}

// เริ่มลากการ์ด
function dragStart(e) {
  e.dataTransfer.setData('text/plain', e.target.dataset.id);
}

// อนุญาตให้วางการ์ด
document.querySelectorAll('.card-container').forEach(container => {
  container.addEventListener('dragover', e => e.preventDefault());
  container.addEventListener('drop', dropCard);
});

function dropCard(e) {
  e.preventDefault();
  const id = e.dataTransfer.getData('text/plain');
  const newStatus = e.currentTarget.parentElement.getAttribute('data-status');

  const data = getBoardData().map(card => {
    if (card.id == id) {
      card.status = newStatus;
    }
    return card;
  });

  saveBoardData(data);
  renderBoard();
}

// โหลดบอร์ดเมื่อหน้าเพจโหลด
function loadBoard() {
  renderBoard();
}
