# jscart

**jscart** เป็นโปรเจ็กต์ที่พัฒนาขึ้นเพื่อสร้างระบบตะกร้าสินค้าแบบครบวงจรโดยใช้ JavaScript, HTML, และ CSS เหมาะสำหรับผู้พัฒนาเว็บไซต์ที่ต้องการติดตั้งฟังก์ชันการจัดการสินค้าและการชำระเงินที่ง่ายต่อการใช้งานและปรับแต่งได้ตามความต้องการ

## คุณสมบัติเด่น
- **ตะกร้าสินค้า**: เพิ่ม, ลบ, และอัปเดตรายการสินค้าได้อย่างรวดเร็ว
- **จัดการชำระเงิน**: รองรับการเลือกวิธีชำระเงินและการประมวลผลการชำระเงินอย่างครบถ้วน
- **แจ้งเตือนผู้ดูแล**: ระบบการแจ้งเตือนหลายช่องทาง เช่น Email, Line, และ Web Push
- **จัดการสินค้า**: การโหลด, การกรอง, และการค้นหาสินค้าที่มีประสิทธิภาพ
- **ธีมที่ปรับเปลี่ยนได้**: รองรับการสลับธีมระหว่างธีมมืดและสว่าง
- **จัดเก็บข้อมูลใน localStorage**: เก็บข้อมูลการตั้งค่าและตะกร้าสินค้าในเครื่องผู้ใช้

## การติดตั้งและการใช้งาน
1. **ดาวน์โหลดโปรเจ็กต์**:
   ```bash
   git clone https://github.com/goragodwiriya/jscart.git
   ```
2. **เปิดไฟล์ `index.html`**:
   เปิดไฟล์ในเบราว์เซอร์เพื่อเริ่มต้นใช้งาน

## โครงสร้างไฟล์
- **`AdminNotifier.js`**: จัดการการส่งการแจ้งเตือนผ่านช่องทางต่าง ๆ
- **`App.js`**: จัดการการเริ่มต้นระบบและการแสดงผลต่าง ๆ ของแอพพลิเคชัน
- **`CartManager.js`**: จัดการฟังก์ชันเกี่ยวกับตะกร้าสินค้า
- **`CheckoutManager.js`**: ประมวลผลการชำระเงินและการยืนยันการสั่งซื้อ
- **`config.js`**: การตั้งค่าทั่วไป เช่น สกุลเงินและค่าจัดส่ง
- **`CustomerManager.js`**: จัดการข้อมูลลูกค้า
- **`CustomerStorage.js`**: จัดเก็บและโหลดข้อมูลลูกค้าจาก localStorage
- **`NotificationManager.js`**: จัดการการแสดงผลการแจ้งเตือน
- **`OrderHistoryManager.js`**: จัดการประวัติการสั่งซื้อ
- **`OrderManager.js`**: จัดการข้อมูลคำสั่งซื้อ
- **`PaymentManager.js`**: จัดการการแสดงและประมวลผลการชำระเงิน
- **`ProductController.js`**: ควบคุมการแสดงผลและการทำงานของสินค้า
- **`ProductService.js`**: บริการดึงข้อมูลและจัดการสินค้า
- **`ProductView.js`**: แสดงผลสินค้าและการจัดการการแสดงผล
- **`Storage.js`**: จัดการการเก็บข้อมูลใน localStorage
- **`TemplateManager.js`**: จัดการเทมเพลต HTML และ modal
- **`ThemeManager.js`**: จัดการธีมมืด/สว่าง
- **`utils.js`**: ฟังก์ชันอรรถประโยชน์ต่าง ๆ

## วิธีการใช้งาน
- เริ่มต้นด้วยการเรียกใช้ฟังก์ชัน `init()` จากแต่ละไฟล์ที่จำเป็น เช่น `CartManager.init()` เพื่อเริ่มต้นระบบตะกร้า หรือ `ProductController.init()` สำหรับการจัดการสินค้า
- ใช้ `ProductService.getProducts()` เพื่อดึงข้อมูลสินค้า และ `ProductView.renderProducts()` เพื่อแสดงผล
- การเปลี่ยนธีมสามารถทำได้ผ่าน `ThemeManager.toggleTheme()`
- การส่งการแจ้งเตือนสามารถเรียกใช้ได้ผ่าน `AdminNotifier.notify()`

## การตั้งค่า
⚠️ คำเตือนสำคัญ
```
- อย่าเก็บ token หรือ key ที่สำคัญไว้ในไฟล์ config.js โดยตรง
- แนะนำให้ใช้งานผ่าน proxy server เพื่อป้องกันการเข้าถึง token โดยตรง
- ตั้งค่า CORS Policy ให้เหมาะสม
```

## การสนับสนุนและการติดต่อ
หากคุณมีคำถามหรือปัญหาใด ๆ สามารถติดต่อผู้พัฒนาได้ที่:
- **เว็บไซต์**: [kotchasan.com](https://www.kotchasan.com)
- **อีเมล**: [admin@goragod.com](mailto:admin@goragod.com)

## ใบอนุญาต
โปรเจ็กต์นี้อยู่ภายใต้ลิขสิทธิ์ [MIT License](https://opensource.org/licenses/MIT) คุณสามารถใช้งาน แก้ไข และแจกจ่ายได้ตามเงื่อนไขของใบอนุญาตนี้
