# 📊 แดชบอร์ดแนวโน้มการเมืองไทย

แดชบอร์ดแบบ Interactive สำหรับติดตามและวิเคราะห์แนวโน้มการเมืองไทยแบบ Real-time พร้อมการเชื่อมต่อข้อมูลจริงจากหน่วยงานราชการและสถาบันต่างๆ

## 🌟 ฟีเจอร์หลัก

### 📈 การแสดงข้อมูล
- **สถิติหลัก**: คะแนนความเชื่อมั่นรัฐบาล, การเติบโตทางเศรษฐกิจ, ดัชนีความพอใจประชาชน
- **กราฟแนวโน้ม**: แนวโน้มความนิยมพรรคการเมือง, ประเด็นการเมืองที่ได้รับความสนใจ
- **ตัวชี้วัดเศรษฐกิจ**: GDP, ดัชนีความเชื่อมั่น, อัตราเงินเฟ้อ
- **ข้อมูลภูมิภาค**: การกระจายความคิดเห็นตามภูมิภาค

### 🔄 Real-time Updates
- อัปเดตข้อมูลอัตโนมัติทุก 5 นาที
- การแจ้งเตือนเมื่อมีข้อมูลใหม่
- ระบบ Cache เพื่อประสิทธิภาพ

### 🎛️ ตัวกรองข้อมูล
- กรองตามช่วงเวลา (3 เดือน, 6 เดือน, 1 ปี, 2 ปี)
- กรองตามประเภทข้อมูล (โพล, เศรษฐกิจ, สังคม)
- ตัวกรองขั้นสูงสำหรับภูมิภาคและประชากร

### 📱 Responsive Design
- รองรับทุกขนาดหน้าจอ
- Progressive Web App (PWA)
- Dark Mode Support

## 🚀 การติดตั้ง

### ความต้องการของระบบ
- Node.js 16+ (สำหรับการพัฒนา)
- Modern Web Browser
- API Keys จากหน่วยงานต่างๆ

### ขั้นตอนการติดตั้ง

1. **Clone โปรเจ็ค**
```bash
git clone https://github.com/your-username/thai-political-dashboard.git
cd thai-political-dashboard
```

2. **ติดตั้ง Dependencies**
```bash
npm install
```

3. **ตั้งค่า Environment Variables**
```bash
cp .env.example .env
```

แก้ไขไฟล์ `.env`:
```env
# API Keys
BOT_API_KEY=your_bot_api_key
NESDB_API_KEY=your_nesdb_api_key
NSO_API_KEY=your_nso_api_key
ECT_API_KEY=your_ect_api_key

# Social Media APIs
TWITTER_API_KEY=your_twitter_api_key
FACEBOOK_API_KEY=your_facebook_api_key
YOUTUBE_API_KEY=your_youtube_api_key

# Database
DATABASE_URL=your_database_url
```

4. **รันโปรเจ็ค**
```bash
# Development
npm run dev

# Production
npm run build
npm start
```

## 📊 แหล่งข้อมูล

### ข้อมูลเศรษฐกิจ
- **ธนาคารแห่งประเทศไทย (BOT)**
  - ดัชนีราคาผู้บริโภค (CPI)
  - อัตราแลกเปลี่ยน
  - ดัชนีความเชื่อมั่นผู้บริโภค
  - อัตราดอกเบี้ย

- **สำนักงานคณะกรรมการพัฒนาการเศรษฐกิจและสังคมแห่งชาติ (NESDB)**
  - ข้อมูล GDP
  - ตัวชี้วัดเศรษฐกิจมหภาค
  - การคาดการณ์เศรษฐกิจ

### ข้อมูลการเมือง
- **สำนักงานคณะกรรมการการเลือกตั้ง (กกต.)**
  - ข้อมูลการเลือกตั้ง
  - สถิติผู้มีสิทธิ์เลือกตั้ง
  - ผลการเลือกตั้ง

- **สำนักงานสถิติแห่งชาติ**
  - ข้อมูลประชากร
  - การสำรวจความคิดเห็น
  - สถิติสังคม

### Social Media Analytics
- **Twitter**: วิเคราะห์ sentiment และ trending topics
- **Facebook**: ติดตามประเด็นร้อนและ engagement
- **YouTube**: วิเคราะห์เนื้อหาการเมือง

## 🛠️ การพัฒนา

### โครงสร้างโปรเจ็ค
```
thai-political-dashboard/
├── index.html              # หน้าหลัก
├── api-integration.js      # API Integration
├── enhanced-styles.css     # Enhanced Styles
├── development-roadmap.md  # แผนการพัฒนา
├── README.md              # เอกสารนี้
├── package.json           # Dependencies
├── .env                   # Environment Variables
└── docs/                  # เอกสารเพิ่มเติม
```

### การเพิ่มฟีเจอร์ใหม่

1. **เพิ่ม API ใหม่**
```javascript
// ใน api-integration.js
async getNewData() {
  try {
    const response = await fetch('/api/new-endpoint');
    return await response.json();
  } catch (error) {
    console.error('Error:', error);
    return this.getFallbackData();
  }
}
```

2. **เพิ่มกราฟใหม่**
```javascript
// สร้างกราฟใหม่
const newChart = new Chart(ctx, {
  type: 'line',
  data: newData,
  options: chartOptions
});
```

3. **เพิ่ม CSS ใหม่**
```css
/* ใน enhanced-styles.css */
.new-feature {
  /* สไตล์ใหม่ */
}
```

### การทดสอบ
```bash
# รัน Unit Tests
npm test

# รัน E2E Tests
npm run test:e2e

# รัน Performance Tests
npm run test:performance
```

## 🔧 การปรับแต่ง

### การเปลี่ยนธีม
แก้ไขไฟล์ `enhanced-styles.css`:
```css
:root {
  --primary-color: #3498db;
  --secondary-color: #2ecc71;
  --background-color: #f8f9fa;
  --text-color: #2c3e50;
}
```

### การเพิ่มภาษาใหม่
1. สร้างไฟล์ `locales/th.json`
2. เพิ่มการแปลใน `i18n.js`
3. อัปเดต language selector

### การปรับแต่ง API
แก้ไขไฟล์ `api-integration.js`:
```javascript
class CustomAPI extends PoliticalDataAPI {
  async getCustomData() {
    // ตรรกะใหม่
  }
}
```

## 📈 การติดตามประสิทธิภาพ

### Metrics ที่ติดตาม
- **Performance**: Page Load Time, Time to Interactive
- **User Engagement**: Session Duration, Bounce Rate
- **Data Quality**: API Response Time, Error Rate
- **Accessibility**: WCAG Compliance Score

### การ Monitor
```bash
# ดู Performance Metrics
npm run monitor

# ดู Error Logs
npm run logs

# ดู Analytics
npm run analytics
```

## 🔐 ความปลอดภัย

### การป้องกัน
- **HTTPS**: ใช้ SSL/TLS encryption
- **API Rate Limiting**: จำกัดการเรียก API
- **Data Validation**: ตรวจสอบข้อมูลที่รับเข้ามา
- **CORS**: ตั้งค่า Cross-Origin Resource Sharing

### การ Audit
```bash
# Security Audit
npm audit

# Dependency Check
npm audit fix

# Code Quality Check
npm run lint
```

## 🤝 การมีส่วนร่วม

### การรายงาน Bug
1. ไปที่ [Issues](https://github.com/your-username/thai-political-dashboard/issues)
2. สร้าง Issue ใหม่
3. อธิบายปัญหาและขั้นตอนการทำซ้ำ

### การส่ง Pull Request
1. Fork โปรเจ็ค
2. สร้าง Feature Branch
3. Commit การเปลี่ยนแปลง
4. ส่ง Pull Request

### Code of Conduct
โปรดอ่าน [Code of Conduct](CODE_OF_CONDUCT.md) ก่อนการมีส่วนร่วม

## 📄 License

โปรเจ็คนี้ใช้ MIT License - ดูรายละเอียดใน [LICENSE](LICENSE) file

## 🙏 การขอบคุณ

### แหล่งข้อมูล
- ธนาคารแห่งประเทศไทย
- สำนักงานคณะกรรมการพัฒนาการเศรษฐกิจและสังคมแห่งชาติ
- สำนักงานคณะกรรมการการเลือกตั้ง
- สำนักงานสถิติแห่งชาติ

### Libraries และ Tools
- [Chart.js](https://www.chartjs.org/) - สำหรับกราฟ
- [Font Awesome](https://fontawesome.com/) - สำหรับไอคอน
- [Google Fonts](https://fonts.google.com/) - สำหรับฟอนต์

## 📞 ติดต่อ

- **Email**: contact@thai-political-dashboard.com
- **Website**: https://thai-political-dashboard.com
- **Twitter**: [@ThaiPoliticalDB](https://twitter.com/ThaiPoliticalDB)
- **GitHub**: [github.com/your-username/thai-political-dashboard](https://github.com/your-username/thai-political-dashboard)

## 🔄 Changelog

### v1.0.0 (2024-01-15)
- 🎉 เปิดตัวเวอร์ชันแรก
- 📊 เพิ่มกราฟพื้นฐาน 4 แบบ
- 🔄 ระบบ Real-time Updates
- 📱 Responsive Design

### v1.1.0 (กำลังพัฒนา)
- 🤖 เพิ่ม AI Features
- 📈 Predictive Analytics
- 🌐 Multi-language Support
- 🔐 Enhanced Security

---

**หมายเหตุ**: โปรเจ็คนี้เป็นเพียงตัวอย่างการพัฒนา แหล่งข้อมูลที่แสดงเป็นเพียงตัวอย่างและอาจไม่ใช่ข้อมูลจริง ในการใช้งานจริงควรเชื่อมต่อกับ API จริงของหน่วยงานต่างๆ