# form-builder

โปรเจ็คนี้เป็นเวอร์ชันเรียบง่ายของเครื่องมือสร้างฟอร์มแบบสแตติก (static form builder) ที่ประกอบด้วยไฟล์หลักเพียงไม่กี่ไฟล์

## ภาพรวม

- โฟลเดอร์โปรเจ็ค: `form-builder`
- ไฟล์หลัก: `index.html`
- ใบอนุญาต: `LICENSE`

โครงงานนี้เหมาะสำหรับตัวอย่าง สาธิต หรือเป็นจุดเริ่มต้นสำหรับการพัฒนาต่อเป็นแอปสร้างฟอร์มแบบโต้ตอบ

## สิ่งที่มีอยู่ในรีโพ

- `index.html` — หน้า HTML หลักของโปรเจ็ค (ฟอร์มตัวอย่าง / UI)
- `LICENSE` — ข้อกำหนดการใช้งานของโปรเจ็ค
- `CLAUDE.md` — โน้ตหรือเอกสารภายใน (ถ้ามี)

## การรัน / ทดลอง

อย่างง่ายที่สุดคือเปิดไฟล์ `index.html` ในเบราว์เซอร์ (ดับเบิลคลิกหรือ `Open File`) หรือแนะนำให้รันผ่านเซิฟเวอร์ HTTP เล็กๆ เพื่อหลีกเลี่ยงปัญหาเกี่ยวกับนโยบาย CORS/ไฟล์ท้องถิ่น:

```bash
# ในโฟลเดอร์โปรเจ็ค ให้รัน (Python 3 ต้องติดตั้งแล้ว)
python3 -m http.server 8000

# แล้วเปิดในเบราว์เซอร์ที่:
http://localhost:8000/
```

ไม่มีการติดตั้งไลบรารีเพิ่มเติมหรือขั้นตอน build ใดๆ — โปรเจ็คเป็นไฟล์สแตติกพร้อมใช้งานทันที

## พัฒนาต่อ

- หากต้องการเพิ่มฟีเจอร์เช่น การบันทึกฟอร์ม, ส่งข้อมูลด้วย AJAX, หรือ UI แบบ dynamic — สามารถเพิ่มไฟล์ JavaScript/CSS และเซิร์ฟเวอร์ฝั่งหลัง (เช่น Node/Express, PHP, หรือ Python) ได้
- แนะนำให้เก็บโครงสร้างไฟล์เป็น `src/` และ `dist/` หากต้องการ workflow ที่มี build step

## ใบอนุญาต

โปรเจ็คนี้อยู่ภายใต้เงื่อนไขในไฟล์ `LICENSE` ที่เก็บไว้ในรีโพเดียวกัน — กรุณาอ่านก่อนใช้หรือแจกจ่าย