# Fashion Store

เว็บไซต์ร้านค้าแฟชั่นออนไลน์ (Fashion Store)

## รายละเอียดโปรเจ็ค
- เว็บไซต์แสดงสินค้าแฟชั่น เช่น เสื้อผ้า เดรส กางเกง กระโปรง ฯลฯ
- ลูกค้าสามารถเลือกสินค้า เลือกไซส์ สี และเพิ่มลงตะกร้า
- ระบบตะกร้าสินค้า พร้อมสรุปยอดและข้อมูลลูกค้า
- รองรับการชำระเงินผ่าน QR Code (PromptPay)
- ข้อมูลสินค้าโหลดจากไฟล์ `api/products.json`
- UI สวยงาม ใช้งานง่าย รองรับมือถือ (Responsive)

## โครงสร้างโปรเจ็ค
```
index.html
api/
  products.json         # ข้อมูลสินค้า (JSON)
assets/
  css/
    style.css           # ไฟล์ CSS หลัก
  js/
    script.js           # ไฟล์ JavaScript หลัก
  images/               # รูปภาพสินค้า
```

## วิธีใช้งาน
1. เปิดไฟล์ `index.html` ด้วยเว็บเบราว์เซอร์ (แนะนำให้รันผ่าน server เช่น XAMPP, WAMP, หรือ Live Server ใน VS Code)
2. เลือกสินค้า เลือกไซส์ สี และเพิ่มลงตะกร้า
3. กรอกข้อมูลลูกค้าและดำเนินการชำระเงินผ่าน QR Code

## การแก้ไข/เพิ่มสินค้า
- แก้ไขไฟล์ `api/products.json` โดยเพิ่ม/ลบ/แก้ไขข้อมูลสินค้าในรูปแบบ JSON
- รูปภาพสินค้าให้วางในโฟลเดอร์ `assets/images/` และระบุ path ในฟิลด์ `image`

## เทคโนโลยีที่ใช้
- HTML5, CSS3 (Flex, Grid, Responsive)
- JavaScript (Vanilla JS)
- Font Awesome (icon)
- QR Code API (สำหรับสร้าง QR ชำระเงิน)

## หมายเหตุ
- ตัวอย่าง QR Code ใช้ API ฟรีและเบอร์โทรตัวอย่าง สามารถเปลี่ยนเบอร์โทรใน `script.js`
- ไม่มีระบบ backend จริง ข้อมูลสินค้าและออเดอร์อยู่ฝั่ง client

---

> พัฒนาเพื่อการศึกษาและฝึกฝนเท่านั้น
