# 🔍 Face Recognition Web Application

เว็บแอปพลิเคชันสำหรับจดจำใบหน้าด้วย AI โดยใช้ Face-API.js เปรียบเทียบใบหน้าระหว่างรูปภาพต้นฉบับกับกล้องเว็บแคมแบบเรียลไทม์

**ผู้พัฒนา:** Goragod Wiriya

---

## ✨ คุณสมบัติ

- 🖼️ **อัปโหลดรูปภาพต้นฉบับ** - รองรับไฟล์ JPG, PNG, GIF
- 🤖 **AI Face Detection** - ตรวจจับใบหน้าอัตโนมัติด้วย TinyFaceDetector
- ✂️ **Auto Crop Face** - ตัดเฉพาะส่วนใบหน้าแสดงผลให้เห็นชัดเจน
- 📹 **Real-time Comparison** - เปรียบเทียบใบหน้าจากกล้องแบบเรียลไทม์
- 📊 **Similarity Score** - แสดงคะแนนความคล้ายคลึงเป็นเปอร์เซ็นต์
- 🎯 **Face Bounding Box** - วาดกรอบรอบใบหน้าที่ตรวจพบ
- 📱 **Responsive Design** - รองรับทั้งเดสก์ท็อปและมือถือ
- 🎨 **Modern UI** - ดีไซน์สไตล์ Minimal Glass Morphism

---

## 🚀 การติดตั้งและใช้งาน

### ข้อกำหนดระบบ
- เว็บเบราว์เซอร์ที่รองรับ WebRTC (Chrome, Firefox, Safari, Edge)
- การเชื่อมต่ออินเทอร์เน็ต (สำหรับโหลด AI Models)
- กล้องเว็บแคม
- Web Server (Apache, Nginx, หรือ Local Server)

### วิธีติดตั้ง

1. **ดาวน์โหลดโปรเจ็ค**

2. **วางไฟล์ในเว็บเซิร์ฟเวอร์**
   ```
   /var/www/html/face-recognition/
   ├── index.html
   ├── script.js
   └── README.md
   ```

3. **เปิดใช้งาน**
   - เปิดเบราว์เซอร์ไปที่ `http://localhost/face-recognition/`
   - อนุญาตการใช้งานกล้องเมื่อมีการแจ้งเตือน

---

## 🎯 วิธีใช้งาน

### ขั้นตอนที่ 1: อัปโหลดรูปภาพต้นฉบับ
1. คลิกปุ่ม **"เลือกรูปภาพ"**
2. เลือกไฟล์รูปภาพที่มีใบหน้าชัดเจน
3. ระบบจะตรวจจับใบหน้าและตัดเฉพาะส่วนหน้าแสดงผล
4. รอข้อความ **"วิเคราะห์ภาพต้นฉบับสำเร็จ!"**

### ขั้นตอนที่ 2: เปิดกล้องเปรียบเทียบ
1. ระบบจะเปิดกล้องอัตโนมัติ
2. มองไปที่กล้อง เฟรมจะแสดงผลการเปรียบเทียบทันที
3. ดูผลลัพธ์ในส่วน **"ผลการตรวจสอบ"**

### การอ่านผลลัพธ์
- **🟢 ตรงกัน!** - ใบหน้าตรงกับรูปต้นฉบับ (similarity > 50%)
- **🔴 ไม่ตรงกัน** - ใบหน้าไม่ตรงกับรูปต้นฉบับ (similarity ≤ 50%)
- **Similarity Score** - คะแนนความคล้ายคลึง (0-100%)

---

## 🛠️ เทคโนโลยีที่ใช้

### Frontend
- **HTML5** - โครงสร้างหน้าเว็บ
- **CSS3** - ดีไซน์ Responsive และ Glass Morphism Effect
- **Vanilla JavaScript** - ตัวจัดการเหตุการณ์และ API

### AI/ML Libraries
- **[Face-API.js v0.22.2](https://github.com/justadudewhohacks/face-api.js)** - ไลบรารี Face Recognition
- **TensorFlow.js** - Backend สำหรับ Machine Learning

### AI Models (โหลดจาก GitHub)
- **TinyFaceDetector** - ตรวจจับใบหน้า (เร็ว, แม่นยำปานกลาง)
- **FaceLandmark68Net** - จุดสำคัญบนใบหน้า 68 จุด
- **FaceRecognitionNet** - สร้าง Face Descriptor สำหรับเปรียบเทียบ

### Web APIs
- **MediaDevices.getUserMedia()** - เข้าถึงกล้องเว็บแคม
- **Canvas API** - ประมวลผลรูปภาพและวาดกรอบ
- **FileReader API** - อ่านไฟล์รูปภาพ

---

## 📋 โครงสร้างไฟล์

```
face-recognition/
├── index.html          # หน้าเว็บหลัก
├── script.js           # JavaScript สำหรับ Face Recognition
└── README.md           # เอกสารนี้
```

### index.html
- โครงสร้าง HTML แบบ Responsive Grid Layout
- CSS Glass Morphism และ Gradient Background
- การเชื่อมต่อ Face-API.js จาก CDN

### script.js
- ฟังก์ชันโหลด AI Models จาก GitHub
- การประมวลผลรูปภาพและ Face Detection
- Real-time Face Comparison และการแสดงผล
- การจัดการ Canvas และ Bounding Box

---

## ⚙️ การปรับแต่ง

### ปรับค่าความแม่นยำ
```javascript
const threshold = 0.5; // ค่าเกณฑ์ (0-1)
// 0.3 = หลวม, 0.5 = ปานกลาง, 0.7 = เข้มงวด
```

### ปรับความเร็วการตรวจสอบ
```javascript
setInterval(async () => {
  // Face detection code
}, 200); // 200ms = 5 FPS, 100ms = 10 FPS
```

### ปรับขนาด Crop Padding
```javascript
const padding = 30; // pixel รอบใบหน้า
// 20 = แน่น, 30 = ปานกลาง, 50 = หลวม
```

---

## 🔧 การแก้ไขปัญหา

### ปัญหาที่พบบ่อย

**1. ไม่สามารถเข้าถึงกล้องได้**
- ✅ ตรวจสอบสิทธิ์การใช้งานกล้องในเบราว์เซอร์
- ✅ ใช้ HTTPS หรือ localhost เท่านั้น
- ✅ กล้องไม่ถูกใช้งานโดยแอปอื่น

**2. โมเดล AI โหลดไม่ได้**
- ✅ ตรวจสอบการเชื่อมต่ออินเทอร์เน็ต
- ✅ รอสักครู่ (โมเดลใหญ่ ~100MB)
- ✅ ตรวจสอบ Console สำหรับ error message

**3. ไม่พบใบหน้าในรูปภาพ**
- ✅ ใช้รูปที่มีใบหน้าชัดเจน
- ✅ ใบหน้าหันหน้าตรงหรือเฉียง ไม่เกิน 45 องศา
- ✅ แสงสว่างเพียงพอ

**4. ความแม่นยำไม่ดี**
- ✅ ใช้รูปภาพต้นฉบับคุณภาพสูง
- ✅ ปรับค่า threshold ให้เหมาะสม
- ✅ ใบหน้าอยู่ตรงกลางของรูป

---

## 🌟 ฟีเจอร์ขั้นสูง

### การบันทึกผลลัพธ์
สามารถเพิ่มฟังก์ชันบันทึกผลการเปรียบเทียบ:
```javascript
// บันทึกลง LocalStorage
localStorage.setItem('faceResults', JSON.stringify(results));
```

### การเปรียบเทียบหลายใบหน้า
ปรับใช้ `detectAllFaces()` แทน `detectSingleFace()`:
```javascript
const detections = await faceapi.detectAllFaces(image)
  .withFaceLandmarks()
  .withFaceDescriptors();
```

### การปรับปรุงประสิทธิภาพ
- ลดขนาดรูปภาพก่อนประมวลผล
- ใช้ Web Workers สำหรับ Face Detection
- Cache AI Models ใน IndexedDB

---

## 📄 License

MIT License - ใช้งานได้อย่างอิสระทั้งเชิงพาณิชย์และส่วนบุคคล

---

## 👨‍💻 ผู้พัฒนา

**Goragod Wiriya**
- 🌐 Website: [https://goragod.com]
- 📧 Email: [admin@goragod.com]
- 💼 GitHub: [@goragodwiriya]

---

## 🙏 กิตติกรรมประกาศ

- **Face-API.js** - Vincent Mühler และทีมพัฒนา
- **TensorFlow.js** - Google TensorFlow Team
- **Pre-trained Models** - Face-API.js Community
