# Kotchasan Framework Documentation

ระบบเอกสารสำหรับ Kotchasan PHP Framework ที่รองรับการแสดงผลไฟล์ Markdown แบบเรียลไทม์

## คุณสมบัติ

- 📚 **แสดงเอกสาร Markdown** - รองรับการแสดงผลไฟล์ .md
- 🌐 **หลายภาษา** - รองรับภาษาไทยและอังกฤษ
- 🎨 **UI สวยงาม** - ออกแบบให้ใช้งานง่ายและสวยงาม
- 🌙 **Dark/Light Mode** - รองรับโหมดมืดและสว่าง
- 📱 **Responsive** - รองรับทุกอุปกรณ์
- ⚡ **เร็ว** - โหลดไฟล์ Markdown แบบเรียลไทม์

## โครงสร้างโปรเจ็ค

```
documentation/
├── index.html              # หน้าหลัก (SPA)
├── docs/                   # เอกสาร Markdown
│   ├── th/                # เอกสารภาษาไทย
│   │   ├── index.md              # หน้าแรก
│   │   ├── installation.md       # คู่มือติดตั้ง
│   │   ├── getting-started.md    # เริ่มต้นใช้งาน
│   │   ├── api-reference.md      # API Reference
│   │   ├── usage-guide.md        # คู่มือการใช้งาน
│   │   └── developer-guide.md   # คู่มือนักพัฒนา
│   └── en/                # เอกสารภาษาอังกฤษ
│       ├── index.md
│       ├── installation.md
│       ├── getting-started.md
│       ├── api-reference.md
│       ├── usage-guide.md
│       └── developer-guide.md
└── README.md              # ไฟล์นี้
```

## การใช้งาน

### 1. เปิดไฟล์ index.html

เปิดไฟล์ `index.html` ในเบราว์เซอร์เพื่อดูเอกสาร

### 2. การนำทาง

- **เมนูด้านซ้าย**: คลิกเพื่อเปลี่ยนเอกสาร
- **เปลี่ยนภาษา**: คลิกปุ่ม 🌐 TH/EN
- **เปลี่ยนธีม**: คลิกปุ่ม 🌙 Dark/☀️ Light

### 3. เพิ่มเอกสารใหม่

1. สร้างไฟล์ .md ใหม่ในโฟลเดอร์ `docs/th/` หรือ `docs/en/`
2. ระบบจะโหลดไฟล์ใหม่อัตโนมัติ
3. ไฟล์จะปรากฏในเมนูด้านซ้าย

### 4. การตั้งชื่อไฟล์

- ใช้ชื่อไฟล์ภาษาอังกฤษ
- ใช้เครื่องหมาย `-` แทนช่องว่าง
- ตัวอย่าง: `getting-started.md`, `api-reference.md`

## การเขียนเอกสาร

### Markdown Syntax

```markdown
# หัวข้อหลัก
## หัวข้อรอง
### หัวข้อย่อย

**ข้อความหนา**
*ข้อความเอียง*

- รายการ
- รายการ

1. รายการลำดับ
2. รายการลำดับ

[ลิงก์](https://example.com)

```php
<?php
echo "Hello World";
```
```

### Code Blocks

```markdown
```php
<?php
// PHP code
```
```

```javascript
// JavaScript code
```

```bash
# Command line
```

## การปรับแต่ง

### เปลี่ยนธีม

คลิกปุ่ม 🌙 Dark/☀️ Light เพื่อเปลี่ยนธีม

### เปลี่ยนภาษา

คลิกปุ่ม 🌐 TH/EN เพื่อเปลี่ยนภาษา

### เพิ่มไฟล์ CSS

แก้ไขส่วน `<style>` ในไฟล์ `index.html`

### เพิ่ม JavaScript

แก้ไขส่วน `<script>` ในไฟล์ `index.html`

## การพัฒนา

### เพิ่มฟีเจอร์ใหม่

1. แก้ไขไฟล์ `index.html`
2. เพิ่มฟังก์ชัน JavaScript
3. อัปเดต CSS

### เพิ่มเอกสาร

1. สร้างไฟล์ .md ใหม่
2. เพิ่มในโฟลเดอร์ `docs/th/` หรือ `docs/en/`
3. ระบบจะโหลดอัตโนมัติ

## การ Deploy

### 1. อัปโหลดไฟล์

อัปโหลดไฟล์ทั้งหมดไปยัง Web Server

### 2. ตั้งค่า Web Server

#### Apache
```apache
<Directory "/path/to/documentation">
    AllowOverride All
    Require all granted
</Directory>
```

#### Nginx
```nginx
server {
    listen 80;
    server_name docs.yourdomain.com;
    root /path/to/documentation;
    index index.html;

    location / {
        try_files $uri $uri/ /index.html;
    }
}
```

### 3. ตั้งค่า HTTPS

```bash
# ใช้ Let's Encrypt
certbot --nginx -d docs.yourdomain.com
```

## การแก้ไขปัญหา

### ไฟล์ไม่โหลด

1. ตรวจสอบชื่อไฟล์
2. ตรวจสอบสิทธิ์ไฟล์
3. ตรวจสอบ Console ในเบราว์เซอร์

### ธีมไม่เปลี่ยน

1. ตรวจสอบ JavaScript
2. ตรวจสอบ CSS
3. ล้าง Cache เบราว์เซอร์

### ภาษาไม่เปลี่ยน

1. ตรวจสอบไฟล์ .md
2. ตรวจสอบชื่อไฟล์
3. ตรวจสอบโครงสร้างโฟลเดอร์

## เอกสารที่รวมอยู่

### 📚 เอกสารหลัก
- **index.md** - หน้าแรกและแนะนำ Kotchasan Framework
- **installation.md** - คู่มือการติดตั้งแบบละเอียด
- **getting-started.md** - คู่มือเริ่มต้นใช้งาน

### 🔧 เอกสารเทคนิค
- **api-reference.md** - คู่มือ API และการใช้งาน
- **usage-guide.md** - คู่มือการใช้งานระบบเอกสาร
- **developer-guide.md** - คู่มือสำหรับนักพัฒนา

### 🌐 หลายภาษา
- **ภาษาไทย** - เอกสารครบถ้วนใน `docs/th/`
- **ภาษาอังกฤษ** - เอกสารครบถ้วนใน `docs/en/`

## การพัฒนาต่อ

### สำหรับผู้ใช้ทั่วไป
- อ่าน [Usage Guide](docs/th/usage-guide.md) เพื่อเรียนรู้การใช้งาน
- ดู [Getting Started](docs/th/getting-started.md) เพื่อเริ่มต้น

### สำหรับนักพัฒนา
- อ่าน [Developer Guide](docs/th/developer-guide.md) เพื่อเรียนรู้การพัฒนาต่อ
- ดู [API Reference](docs/th/api-reference.md) เพื่อเรียนรู้ API

## การสนับสนุน

หากคุณพบปัญหาหรือต้องการความช่วยเหลือ:

- 📧 Email: support@kotchasan.com
- 💬 Discord: [Kotchasan Community](https://discord.gg/kotchasan)
- 🐛 GitHub Issues: [Report Bug](https://github.com/kotchasan/framework/issues)

## License

MIT License - ดูไฟล์ LICENSE สำหรับรายละเอียด

---

**Kotchasan Framework Documentation** - ระบบเอกสารที่ใช้งานง่ายและสวยงาม
