# Dashboard Project

A simple web-based dashboard for displaying key metrics from CSV data, with backend support in PHP.

## Features
- Responsive dashboard UI (HTML/CSS/JS)
- Loads and displays key metrics from `data/key_metrics.csv`
- Backend API in PHP for data handling
- Modular code structure for easy maintenance

## Project Structure
```
index.html                # Main dashboard page
css/style.css             # Stylesheet
js/script.js              # Frontend logic
php/
  api_handler.php         # Main API endpoint
  csv_handler.php         # CSV file operations
  data_provider.php       # Data logic
  db_handler.php          # (Optional) Database handler
  default.config.php      # Default configuration file (must be renamed)
  config.php              # (Created by renaming default.config.php)
data/key_metrics.csv      # Data source
LICENSE                   # License file
```

## Getting Started
1. ดาวน์โหลดไฟล์โปรเจ็คจากหน้า Repo:
   - ไปที่ [https://code.goragod.com/dashboard](https://code.goragod.com/dashboard)
   - กดปุ่มดาวน์โหลด (Download) เพื่อรับไฟล์ ZIP หรือ TAR ของโปรเจ็ค
2. แตกไฟล์ ZIP/TAR ที่ดาวน์โหลดมา
3. คัดลอกโฟลเดอร์โปรเจ็คไปยัง document root ของเว็บเซิร์ฟเวอร์ (เช่น `/var/www/html/dashboard` หรือ `htdocs/dashboard`)
4. **สำคัญ:** เปลี่ยนชื่อไฟล์ `php/default.config.php` เป็น `php/config.php`
5. ตรวจสอบให้เซิร์ฟเวอร์รองรับ PHP (แนะนำ PHP 7.0 ขึ้นไป)
6. เปิดไฟล์ `index.html` ผ่านเว็บเบราว์เซอร์

## Usage Prompt
> "สร้าง Dashboard แสดงข้อมูล key metrics จากไฟล์ CSV โดยใช้ HTML, CSS, JavaScript และ PHP สำหรับ backend API"

## Author
Goragod Wiriya

## Repository
[https://code.goragod.com/dashboard](https://code.goragod.com/dashboard)
