<?php
// Configuration for data_provider.php

return [
    // Rate limiting settings
    'rate_limit' => [
        'max_requests_per_hour' => 1000, // จำกัด 1000 requests ต่อชั่วโมง (16.7 requests/minute)
        'time_window' => 3600, // 1 ชั่วโมง (3600 วินาที)
        'enabled' => true // เปิด rate limiting
    ],

    // Allowed data sources
    'allowed_sources' => [
        'api_revenue',
        'db_sales',
        'csv_metrics',
        'json_metrics',
        'json_chart'
    ],

    // Security settings
    'security' => [
        'log_errors' => true, // เปิด/ปิด error logging
        'strict_validation' => true // เปิด/ปิด strict parameter validation
    ],

    // Performance settings
    'performance' => [
        'enable_cache' => false, // เปิด/ปิด response caching (ยังไม่ implement)
        'cache_ttl' => 300, // Cache TTL in seconds
        'simulate_latency' => false // เปิด/ปิด network latency simulation
    ]
];
