// Simple login logic (demo only)
document.getElementById('login-form').addEventListener('submit', function(e) {
  e.preventDefault();
  document.getElementById('login-container').style.display = 'none';
  document.getElementById('dashboard').style.display = 'flex';
  document.getElementById('user-name').textContent = document.getElementById('username').value || 'Admin';
});

// Example user data for the table
const users = [
  {name: 'สมชาย ใจดี', position: 'เจ้าหน้าที่', department: 'บุคคล', score: 90, status: 'ปกติ'},
  {name: 'อรทัย สายใจ', position: 'หัวหน้าแผนก', department: 'บัญชี', score: 85, status: 'ปกติ'},
  {name: 'วิชัย ทองดี', position: 'เจ้าหน้าที่', department: 'ไอที', score: 92, status: 'ปกติ'},
  {name: 'สุภาพร ศรีสุข', position: 'ผู้จัดการ', department: 'การเงิน', score: 80, status: 'รอตรวจสอบ'},
  {name: 'ปิยะดา รักดี', position: 'เจ้าหน้าที่', department: 'บุคคล', score: 91, status: 'ปกติ'},
];

function renderUserTable() {
  const tbody = document.getElementById('user-table-body');
  tbody.innerHTML = '';
  users.forEach(u => {
    const tr = document.createElement('tr');
    tr.innerHTML = `<td>${u.name}</td><td>${u.position}</td><td>${u.department}</td><td>${u.score}</td><td>${u.status}</td>`;
    tbody.appendChild(tr);
  });
}
renderUserTable();

// Chart rendering (no framework, using Chart.js CDN)
function loadCharts() {
  if (!window.Chart) return;
  // Chart 1: Monthly Scores
  new Chart(document.getElementById('chart1').getContext('2d'), {
    type: 'line',
    data: {
      labels: ['ม.ค.', 'ก.พ.', 'มี.ค.', 'เม.ย.', 'พ.ค.', 'มิ.ย.', 'ก.ค.'],
      datasets: [{
        label: 'คะแนนเฉลี่ย',
        data: [82, 85, 88, 90, 87, 89, 91],
        borderColor: '#0D47A1',
        backgroundColor: 'rgba(13,71,161,0.08)',
        fill: true,
        tension: 0.4,
        pointRadius: 5,
        pointBackgroundColor: '#1976D2',
      }]
    },
    options: {
      plugins: {legend: {display: false}},
      scales: {
        y: {beginAtZero: true, max: 100}
      }
    }
  });
  // Chart 2: Department Scores
  new Chart(document.getElementById('chart2').getContext('2d'), {
    type: 'bar',
    data: {
      labels: ['บุคคล', 'บัญชี', 'ไอที', 'การเงิน'],
      datasets: [{
        label: 'คะแนนเฉลี่ย',
        data: [90, 85, 92, 80],
        backgroundColor: ['#1976D2', '#42A5F5', '#64B5F6', '#90CAF9'],
        borderRadius: 8,
      }]
    },
    options: {
      plugins: {legend: {display: false}},
      scales: {
        y: {beginAtZero: true, max: 100}
      }
    }
  });
}

// Load Chart.js from CDN and render charts
document.addEventListener('DOMContentLoaded', function() {
  const script = document.createElement('script');
  script.src = 'https://cdn.jsdelivr.net/npm/chart.js';
  script.onload = loadCharts;
  document.body.appendChild(script);
});
