# Car Rent Mock

โปรเจ็คนี้เป็นเว็บไซต์ตัวอย่างสำหรับแสดงรายการรถเช่าแบบง่าย ๆ (mock) โดยเก็บข้อมูลรถไว้ในไฟล์ JSON และแสดงผลด้วย HTML/CSS/JavaScript แบบ client-side เท่านั้น — ไม่มี backend จริง การออกแบบเน้นความเรียบง่ายเพื่อให้เป็นฐานสำหรับทดลอง UI, การปรับแต่งข้อมูลตัวอย่าง และการทดสอบฟีเจอร์เบื้องต้น

โครงสร้างไฟล์สำคัญ

- `index.html` — หน้าเว็บหลัก
- `css/style.css`, `css/responsive.css` — สไตล์สำหรับหน้าเว็บ
- `js/main.js` — จุดเริ่มต้นของสคริปต์ front-end
- `js/api.js` — ฟังก์ชันโหลดข้อมูล (จาก `data/cars.json`)
- `js/ui.js` — ฟังก์ชันสร้าง UI และจัดการเหตุการณ์ (events)
- `js/utils.js` — ฟังก์ชันช่วยเหลือต่าง ๆ
- `data/cars.json` — ข้อมูลรถตัวอย่าง
- `img/` — รูปภาพรถและ assets อื่น ๆ

วิธีใช้งาน (เรียกดูในเครื่อง)

1. เปิด `index.html` โดยตรงในเบราว์เซอร์ (ไฟล์ static) หรือ
2. รันเซิร์ฟเวอร์ไฟล์ static แบบง่ายในเครื่อง (แนะนำ) เช่น ใช้ Python:

```bash
# สำหรับ Python 3.x
cd /path/to/car-rent-mock
python3 -m http.server 8000
# แล้วเปิด http://localhost:8000
```

การปรับแต่งที่สำคัญ

- เปลี่ยนข้อมูลรถ: แก้ `data/cars.json` เพื่อเพิ่ม/แก้ไขรถตัวอย่าง (id, ชื่อ, ราคา, รูปภาพ, รายละเอียด)
- เพิ่มรูปภาพรถ: วางไฟล์รูปไว้ที่ `img/` และอัปเดตค่า `image` ใน `data/cars.json`
- ปรับแต่งสไตล์: แก้ไฟล์ใน `css/` เพื่อเปลี่ยนธีม สี และการจัดวาง
- ปรับพฤติกรรม UI: แก้ `js/ui.js` และ `js/main.js` เพื่อเพิ่มฟีเจอร์ เช่น กรอง/เรียงลำดับ/จอง
- แยก backend: หากต้องการเชื่อม API จริง ให้เปลี่ยน `js/api.js` ให้เรียก endpoint จาก server แทนการโหลดไฟล์ `data/cars.json`

โครงแบบข้อมูล (data/cars.json)

ตัวอย่างรายการรถใน `data/cars.json` มีรูปแบบประมาณนี้:

```json
{
  "id": "almera-001",
  "make": "Nissan",
  "model": "Almera",
  "pricePerDay": 1200,
  "image": "img/car_almera.webp",
  "seats": 5,
  "transmission": "AT",
  "fuel": "Petrol",
  "description": "Compact economy sedan suitable for city driving."
}
```

## Prompt

ตัวอย่าง Prompt ภาษาไทยสำหรับ “ออกแบบโปรเจ็ค” ที่คุณสามารถคัดลอกไปใช้กับ Google AI Studio หรือโมเดลอื่นได้ทันที

Prompt ที่ 1 — แบบย่อ (Copy-paste) "ออกแบบสถาปัตยกรรมสำหรับเว็บไซต์แสดงรายการรถเช่าแบบ static mock (ไฟล์ใน repository: index.html, css, js, cars.json, img). ให้สรุปโครงสร้างไฟล์ แนะนำ data model JSON สำหรับรถ 1 ตัว (ฟิลด์สำคัญ) และเสนอ 3 ทางเลือกสำหรับการขยายเป็นระบบจริง (เช่น backend แบบ REST, GraphQL, หรือ serverless) โดยให้เหตุผลสั้น ๆ แต่ชัดเจน — ตอบเป็นภาษาไทย"

Prompt ที่ 2 — แบบละเอียด (ออกแบบครบ) "ฉันมี repository สำหรับเว็บไซต์ตัวอย่าง ‘Car Rent Mock’ ที่ประกอบด้วย index.html, โฟลเดอร์ css, js, cars.json และ img — โปรดออกแบบโปรเจ็คฉบับเต็มสำหรับเปลี่ยนจาก mock เป็นระบบผลิตจริง โดยให้รายละเอียดดังนี้

- สถาปัตยกรรมสูง (3 ชั้นหรือ microservices) พร้อมแผนการเลือกระหว่าง REST/GraphQL และเหตุผล
- ข้อกำหนดของ API (endpoints หลัก, method, payload ตัวอย่าง, error codes)
- JSON Schema สำหรับ cars และตัวอย่าง fixture data 3 รายการ
- โครงสร้างฐานข้อมูลที่แนะนำ (SQL/NoSQL) พร้อมเหตุผล
- แผนการ deployment เบื้องต้น (CI/CD, hosting options, storage สำหรับรูป)
- แนะนำการทดสอบอัตโนมัติที่สำคัญ (unit, integration, e2e) และแนะนำไลบรารีที่เหมาะสม
- แผนการเพิ่มฟีเจอร์พื้นฐาน: การกรอง/เรียงลำดับ การจองและการจัดการสถานะการจอง

ส่งคำตอบเป็นภาษาไทย โดยย่อแต่ครบ มีตัวอย่างโค้ดสั้น ๆ (ไม่เกิน 12 บรรทัดต่อโค้ดตัวอย่าง) สำหรับ endpoint GET /cars และ payload การสร้างรถใหม่"

Prompt ที่ 3 — สำหรับนักพัฒนา: API contract + สกีมา "ช่วยออกแบบ API contract สำหรับระบบรถเช่า (backend) ที่จะเชื่อมต่อกับ frontend ของโปรเจ็คนี้ ให้รายละเอียดดังนี้

- Endpoint list: /cars (GET, POST), /cars/{id} (GET, PUT, DELETE), /bookings (POST, GET) — ระบุ input/output schema เป็น JSON Schema แบบสมบูรณ์สำหรับแต่ละ endpoint
- ตัวอย่าง request/response สำหรับ GET /cars, POST /cars และ POST /bookings
- ข้อกำหนดการจับ error และ status codes ที่ใช้บ่อย (เช่น 400, 404, 409, 500)
- ข้อเสนอแนะสั้น ๆ สำหรับ authentication (JWT) และ rate limiting

ตอบเป็นภาษาไทย พร้อม JSON Schema และตัวอย่าง JSON ที่สามารถคัดลอกไปทดสอบได้"

Prompt ที่ 4 — เน้น UX, accessibility และ data flow "ออกแบบส่วน UX/flow ของหน้าแสดงรายการรถเช่าสำหรับ desktop และ mobile ให้ละเอียดพอที่จะให้นักพัฒนาทำงานต่อได้

- wireframe textual สำหรับหน้าหลัก, หน้า detail รถ, หน้า booking form (mobile-first)
- interaction flow เมื่อผู้ใช้กรอง/เรียงลำดับ/คลิกดูรายละเอียด/เริ่มการจอง
- ข้อแนะนำ accessibility (ARIA attributes, keyboard nav, color contrast) และ performance tips (lazy-load รูป, pagination หรือ virtual scroll)

ตอบเป็นภาษาไทย และรวมตัวอย่าง HTML snippet สำหรับ placeholder image และ attribute ARIA สั้น ๆ"

เพิ่มเติมที่แนะนำให้ใส่ใน prompt เมื่อจะใช้จริง

- ระบุเป้าหมาย (เช่น: “ออกแบบเพื่อ production-ready, รองรับ 10k users/day” หรือ “prototype สำหรับทดสอบ UX”)
- ระบุข้อจำกัดเทคโนโลยีที่ต้องการ (เช่น “ต้องการใช้ PostgreSQL และ Node.js/Express” หรือ “ต้องการ Firebase only”)
- ถ้าต้องการโค้ดที่ทำงานได้จริง ให้บอกเวอร์ชัน Node/Python และระดับรายละเอียด (pseudo-code vs. ready-to-run)

## เกี่ยวกับ

- ผู้แต่ง: Goragod Wiriya
- AI: Google AI Studio