# 🎨 Banner Designer

โปรแกรมสร้างแบนเนอร์ออนไลน์ที่ใช้งานง่าย สร้างด้วย HTML5 Canvas, CSS และ JavaScript

![Banner Designer](https://img.shields.io/badge/Version-1.0.0-blue)
![License](https://img.shields.io/badge/License-MIT-green)
![Language](https://img.shields.io/badge/Language-Thai-red)

## 📋 คุณสมบัติ

### 🖼️ การจัดการแคนวาส
- **ขนาดแบนเนอร์หลากหลาย**: Facebook Cover, Instagram Square/Story, Twitter Header และอื่นๆ
- **ขนาดกำหนดเอง**: ระบุขนาดที่ต้องการได้เอง
- **พื้นหลังปรับแต่งได้**: เปลี่ยนสี อัพโหลดรูปภาพ และปรับความโปร่งใส

### 📝 การจัดการข้อความ
- **ฟอนต์หลากหลาย**: Kanit, Noto Sans Thai, Arial, Georgia และอื่นๆ
- **การจัดรูปแบบ**: ตัวหนา, ตัวเอียง, ขีดเส้นใต้
- **การจัดวาง**: ซ้าย, กลาง, ขวา
- **ปรับขนาดได้**: ลากมุมเพื่อปรับขนาดแบบสัดส่วน
- **เอฟเฟกต์ขั้นสูง**: เงา, เส้นขอบ, ความโปร่งใส, การหมุน

### 🏷️ การจัดการรูปภาพ
- **เพิ่มโลโก้**: อัพโหลดและปรับขนาดรูปภาพ
- **รักษาสัดส่วน**: รูปภาพจะคงสัดส่วนเดิมเมื่อปรับขนาด
- **การลากและวาง**: เคลื่อนย้ายรูปภาพได้อย่างง่ายดาย

### ⌨️ Keyboard Shortcuts
- **Ctrl+Z**: ยกเลิกการทำงาน (Undo)
- **Ctrl+Y**: ทำซ้ำ (Redo)
- **Ctrl+C**: คัดลอกองค์ประกอบ
- **Ctrl+V**: วางองค์ประกอบ
- **Ctrl+D**: ทำซ้ำองค์ประกอบ
- **Delete**: ลบองค์ประกอบที่เลือก
- **Esc**: ยกเลิกการเลือก

### 💾 การส่งออก
- **รูปแบบหลากหลาย**: PNG (รองรับความโปร่งใส), JPEG, WebP
- **คุณภาพสูง**: ส่งออกในคุณภาพต้นฉบับ

## 🚀 การใช้งาน

### การเริ่มต้น
1. เปิดไฟล์ `index.html` ในเว็บเบราว์เซอร์
2. เลือกขนาดแบนเนอร์จาก dropdown หรือกำหนดขนาดเอง
3. ปรับแต่งพื้นหลังตามต้องการ

### การเพิ่มข้อความ
1. คลิกปุ่ม "+ เพิ่มข้อความ"
2. พิมพ์ข้อความในช่อง "ใส่ข้อความ"
3. ปรับแต่งฟอนต์, ขนาด, สี และการจัดวาง
4. ลากเพื่อย้ายตำแหน่ง หรือลากมุมเพื่อปรับขนาด

### การเพิ่มรูปภาพ
1. คลิก "Choose File" ในส่วน "เพิ่มโลโก้"
2. เลือกไฟล์รูปภาพจากคอมพิวเตอร์
3. ปรับขนาดและตำแหน่งตามต้องการ

### การส่งออก
1. เลือกรูปแบบไฟล์ที่ต้องการ (PNG, JPEG, WebP)
2. คลิกปุ่ม "📥 ดาวน์โหลด"
3. ไฟล์จะถูกดาวน์โหลดอัตโนมัติ

## 🛠️ เทคโนโลยีที่ใช้

- **HTML5 Canvas**: สำหรับการวาดและแสดงผล
- **CSS3**: การจัดแต่งหน้าตา และ responsive design
- **Vanilla JavaScript**: การจัดการ logic และ event handling
- **Google Fonts**: ฟอนต์ Kanit และ Noto Sans Thai

## 📁 โครงสร้างโปรเจ็ค

```
banner/
├── index.html          # หน้าหลักของแอปพลิเคชัน
├── style.css           # ไฟล์ CSS สำหรับการจัดแต่ง
├── script.js           # ไฟล์ JavaScript หลัก
└── README.md           # เอกสารอธิบายโปรเจ็ค
```

## 🎯 ขนาดแบนเนอร์ที่รองรับ

| แพลตฟอร์ม | ขนาด (พิกเซล) | รายละเอียด |
|-----------|---------------|------------|
| Facebook Cover | 1200×630 | ภาพปกเพจเฟซบุ๊ค |
| Facebook Event | 1584×396 | ภาพปกอีเวนต์ |
| Twitter Header | 1128×191 | ภาพหัวโปรไฟล์ทวิตเตอร์ |
| Instagram Square | 1080×1080 | โพสต์สี่เหลี่ยมจัตุรัส |
| Instagram Story | 1080×1920 | สตอรี่อินสตาแกรม |
| Banner 728×90 | 728×90 | แบนเนอร์เว็บไซต์มาตรฐาน |
| Mobile Banner | 320×50 | แบนเนอร์มือถือ |

## 🔧 การติดตั้งและใช้งาน

### ความต้องการของระบบ
- เว็บเบราว์เซอร์ที่รองรับ HTML5 Canvas (Chrome, Firefox, Safari, Edge)
- JavaScript เปิดใช้งาน

### การติดตั้ง
```bash
# Clone หรือดาวน์โหลดโปรเจ็ค
git clone [repository-url]

# เข้าไปในโฟลเดอร์
cd banner

# เปิดไฟล์ index.html ด้วยเว็บเบราว์เซอร์
# หรือใช้ Live Server ใน VS Code
```

### การใช้งานแบบ Local Server
```bash
# ใช้ Python 3
python -m http.server 8000

# ใช้ Node.js (ต้องติดตั้ง http-server ก่อน)
npx http-server

# ใช้ PHP
php -S localhost:8000
```

จากนั้นเปิด `http://localhost:8000` ในเว็บเบราว์เซอร์

## 📝 License

โปรเจ็คนี้ใช้ MIT License - ดูรายละเอียดได้ที่ไฟล์ [LICENSE](LICENSE)

## 👨‍💻 ผู้พัฒนา

- **Goragod Wiriya** - *ผู้แต่ง* - [GitHub Profile](https://github.com/goragodwiriya)
- **Claude AI** - *ผู้ช่วยพัฒนา* - Anthropic

## 🙏 กิตติกรรมประกาศ

- [Google Fonts](https://fonts.google.com/) - สำหรับฟอนต์ Kanit และ Noto Sans Thai
- [HTML5 Canvas API](https://developer.mozilla.org/en-US/docs/Web/API/Canvas_API) - สำหรับการวาดและแสดงผล

---

## 🎨 AI Prompt สำหรับสร้างโปรเจ็คนี้

```
สร้างเว็บแอปพลิเคชันสำหรับออกแบบแบนเนอร์ออนไลน์ด้วยคุณสมบัติต่อไปนี้:

**คุณสมบัติหลัก:**
1. ใช้ HTML5 Canvas สำหรับการวาดและแสดงผล
2. สามารถเลือกขนาดแบนเนอร์ได้หลากหลาย (Facebook, Instagram, Twitter, ฯลฯ)
3. สามารถกำหนดขนาดแบนเนอร์เองได้
4. เพิ่มและแก้ไขข้อความได้ (ฟอนต์, ขนาด, สี, การจัดวาง)
5. เพิ่มรูปภาพ/โลโก้ได้
6. เปลี่ยนพื้นหลัง (สีหรือรูปภาพ) และปรับความโปร่งใสได้
7. ลากและวางเพื่อย้ายองค์ประกอบ
8. ปรับขนาดองค์ประกอบด้วยการลากมุม
9. ส่งออกเป็นรูปภาพ (PNG, JPEG, WebP)

**การใช้งาน:**
- ใช้ฟอนต์ไทยที่สวยงาม (Kanit, Noto Sans Thai)
- มี UI ที่ใช้งานง่าย เป็นภาษาไทย
- รองรับ keyboard shortcuts (Ctrl+Z, Ctrl+C, Ctrl+V, Delete, ฯลฯ)
- มีระบบ Undo/Redo
- การออกแบบ responsive

**เทคโนโลยี:**
- HTML5, CSS3, Vanilla JavaScript
- ไม่ใช้ framework หรือ library ภายนอก
- รองรับเว็บเบราว์เซอร์สมัยใหม่

สร้างเป็น 3 ไฟล์: index.html, style.css, script.js
```

**การพัฒนาเพิ่มเติมด้วย Claude AI:**
โปรเจ็คนี้ได้รับการพัฒนาและปรับปรุงด้วยความช่วยเหลือจาก Claude AI รวมถึงการเพิ่มฟีเจอร์ขั้นสูงเช่น:
- ระบบ History (Undo/Redo)
- Keyboard Shortcuts
- การปรับปรุง UX/UI
- การเพิ่มประสิทธิภาพโค้ด

---

*สร้างด้วยความใส่ใจและเทคโนโลยี AI 🤖*
