// Global Configuration
const CONFIG = {
    ANIMATION_DURATION: 300,
    NOTIFICATION_DURATION: 3000,
    MIN_ORDER_AMOUNT: 100,
    DELIVERY_FEE: 20,
    FREE_DELIVERY_AMOUNT: 300,
    TAX_RATE: 0.07,
    CURRENCY: 'THB',
    LOCALE: 'th-TH',
    API_ENDPOINT: 'https://api.example.com',
    STORAGE_KEYS: {
        CART: 'bakery_cart',
        USER: 'bakery_user',
        SETTINGS: 'bakery_settings',
        CUSTOMER: 'bakery_customer'
    }
};

// Global State
const State = {
    cart: [],
    products: [],
    currentUser: null,
    settings: null,
    notifications: [],
    isLoading: false
};

// Global Event Bus
const EventBus = {
    listeners: {},

    on(event, callback) {
        if (!this.listeners[event]) {
            this.listeners[event] = [];
        }
        this.listeners[event].push(callback);
    },

    emit(event, data) {
        if (this.listeners[event]) {
            this.listeners[event].forEach(callback => callback(data));
        }
    },

    off(event, callback) {
        if (this.listeners[event]) {
            this.listeners[event] = this.listeners[event]
                .filter(cb => cb !== callback);
        }
    }
};
