export class ProductManager {
    constructor() {
        this.storageKey = 'productData';
        this.loadProducts();
    }

    loadProducts() {
        const savedProducts = localStorage.getItem(this.storageKey);
        this.products = savedProducts ? JSON.parse(savedProducts) : {
            items: [
                {
                    id: 'custard-bread',
                    name: 'ขนมปังสังขยาไข่',
                    price: 35,
                    description: 'สังขยาไข่แท้ เนื้อนุ่ม หอมมัน',
                    image: 'assets/images/custard-bread.svg',
                    category: 'signature',
                    available: true,
                    stock: 100,
                    options: []
                }
            ],
            categories: [
                {
                    id: 'signature',
                    name: 'เมนูแนะนำ',
                    order: 1
                }
            ]
        };
    }

    saveProducts() {
        localStorage.setItem(this.storageKey, JSON.stringify(this.products));
    }

    getProducts() {
        return this.products.items.filter(item => item.available);
    }

    getProduct(id) {
        return this.products.items.find(item => item.id === id);
    }

    updateProduct(id, data) {
        const index = this.products.items.findIndex(item => item.id === id);
        if (index !== -1) {
            this.products.items[index] = { ...this.products.items[index], ...data };
            this.saveProducts();
            return true;
        }
        return false;
    }

    addProduct(product) {
        this.products.items.push({
            id: this.generateId(product.name),
            available: true,
            stock: 0,
            options: [],
            ...product
        });
        this.saveProducts();
    }

    deleteProduct(id) {
        const index = this.products.items.findIndex(item => item.id === id);
        if (index !== -1) {
            this.products.items.splice(index, 1);
            this.saveProducts();
            return true;
        }
        return false;
    }

    generateId(name) {
        return name
            .toLowerCase()
            .replace(/\s+/g, '-')
            .replace(/[^\w\-]+/g, '')
            .replace(/\-\-+/g, '-')
            .replace(/^-+/, '')
            .replace(/-+$/, '');
    }
}
