export class CustomerStorage {
    constructor() {
        this.storageKey = 'customerInfo';
        this.loadCustomerInfo();
    }

    loadCustomerInfo() {
        const savedInfo = localStorage.getItem(this.storageKey);
        this.customerInfo = savedInfo ? JSON.parse(savedInfo) : {
            name: '',
            phone: '',
            address: '',
            email: '',
            preferredPayment: '',
            deliveryNotes: '',
            orderHistory: []
        };
    }

    saveCustomerInfo() {
        localStorage.setItem(this.storageKey, JSON.stringify(this.customerInfo));
    }

    updateCustomerInfo(info) {
        this.customerInfo = { ...this.customerInfo, ...info };
        this.saveCustomerInfo();
    }

    addToOrderHistory(order) {
        this.customerInfo.orderHistory.push({
            ...order,
            date: new Date().toISOString()
        });
        this.saveCustomerInfo();
    }

    getOrderHistory() {
        return this.customerInfo.orderHistory;
    }

    getDeliveryInfo() {
        const { name, phone, address, deliveryNotes } = this.customerInfo;
        return { name, phone, address, deliveryNotes };
    }
}
