const NotificationService = {
    async sendOrderNotification(order) {
        const customer = State.customer;
        const notifications = customer.preferences.notifications;
        
        const promises = [];
        
        // Line Notification
        if (notifications.line) {
            promises.push(this.sendLineNotification(order));
        }
        
        // Discord Notification
        if (notifications.discord) {
            promises.push(this.sendDiscordNotification(order));
        }
        
        // Telegram Notification
        if (notifications.telegram) {
            promises.push(this.sendTelegramNotification(order));
        }
        
        // Email Notification
        if (notifications.email) {
            promises.push(this.sendEmailNotification(order));
        }
        
        // Web Push Notification
        if (notifications.webPush) {
            promises.push(this.sendWebPushNotification(order));
        }
        
        try {
            await Promise.all(promises);
            return true;
        } catch (error) {
            console.error('Notification error:', error);
            return false;
        }
    },

    async sendLineNotification(order) {
        const message = this.formatOrderMessage(order);
        
        try {
            const response = await fetch('YOUR_LINE_NOTIFY_ENDPOINT', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    message: message
                })
            });
            
            return response.ok;
        } catch (error) {
            console.error('Line notification error:', error);
            return false;
        }
    },

    async sendDiscordNotification(order) {
        const embed = {
            title: `🛍️ คำสั่งซื้อใหม่ #${order.id}`,
            color: 0x00ff00,
            fields: [
                {
                    name: '👤 ลูกค้า',
                    value: order.customer.name
                },
                {
                    name: '📱 เบอร์โทร',
                    value: order.customer.phone
                },
                {
                    name: '📦 รายการสินค้า',
                    value: order.items.map(item => 
                        `- ${item.name} x${item.quantity}`
                    ).join('\n')
                },
                {
                    name: '💰 ยอดรวม',
                    value: Utils.formatPrice(order.total)
                }
            ],
            timestamp: new Date()
        };

        try {
            const response = await fetch('YOUR_DISCORD_WEBHOOK', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({ embeds: [embed] })
            });
            
            return response.ok;
        } catch (error) {
            console.error('Discord notification error:', error);
            return false;
        }
    },

    formatOrderMessage(order) {
        return `
🆕 คำสั่งซื้อใหม่ #${order.id}
👤 ลูกค้า: ${order.customer.name}
📱 เบอร์โทร: ${order.customer.phone}
📍 ที่อยู่: ${order.customer.address}

🛍️ รายการสินค้า:
${order.items.map(item => `- ${item.name} x${item.quantity} (${Utils.formatPrice(item.price * item.quantity)})`).join('\n')}

💰 ยอดรวม: ${Utils.formatPrice(order.total)}
💳 ชำระโดย: ${order.paymentMethod}
        `.trim();
    }
};
