# 📅 ระบบจัดการนัดหมาย (Appointment Management System)

ระบบจัดการนัดหมายแบบ Progressive Web App (PWA) ที่ทันสมัย รองรับการทำงานทั้งออนไลน์และออฟไลน์ ด้วยการออกแบบแบบ Glassmorphism และ Font Awesome Icons

![Appointment System](https://img.shields.io/badge/Version-1.0.0-blue)
![PWA Ready](https://img.shields.io/badge/PWA-Ready-green)
![Offline Support](https://img.shields.io/badge/Offline-Support-orange)
![Thai Language](https://img.shields.io/badge/Language-Thai-red)

## ✨ คุณสมบัติหลัก

### 🎯 การจัดการนัดหมาย
- **บันทึกนัดหมาย**: รองรับการพิมพ์และการใช้เสียง (Speech Recognition)
- **ดูรายการนัดหมาย**: แสดงนัดหมายตามวันที่ (วันนี้, พรุ่งนี้, สัปดาห์นี้, หรือทั้งหมด)
- **การแจ้งเตือน**: แจ้งเตือนก่อนนัดหมาย 30 นาที
- **ข้อมูลครบถ้วน**: เก็บชื่องาน, วันที่, เวลา, และสถานที่

### 💻 เทคโนโลยีที่ใช้
- **Frontend**: HTML5, CSS3, Vanilla JavaScript
- **Database**: IndexedDB (สำหรับการทำงานแบบออฟไลน์)
- **PWA**: Service Worker, Web App Manifest
- **Design**: Glassmorphism, Font Awesome Icons
- **Typography**: Google Fonts (Prompt)
- **Speech**: Web Speech API

### 📱 การรองรับ
- ✅ Responsive Design - ใช้งานได้ทั้งมือถือและเดสก์ท็อป
- ✅ Progressive Web App - ติดตั้งได้เหมือน App
- ✅ Offline First - ทำงานได้แม้ไม่มีอินเทอร์เน็ต
- ✅ Speech Recognition - รองรับการสั่งงานด้วยเสียง
- ✅ Push Notifications - แจ้งเตือนนัดหมาย

## 🚀 การติดตั้งและใช้งาน

### การติดตั้งแบบง่าย
1. **ดาวน์โหลดไฟล์**

2. **เปิดใน Web Server**
   ```bash
   # ใช้ Python
   python -m http.server 8000

   # หรือใช้ Node.js
   npx serve .

   # หรือใช้ PHP
   php -S localhost:8000
   ```

3. **เข้าใช้งาน**
   - เปิดเบราว์เซอร์ไปที่ `http://localhost:8000`
   - บน Mobile: สามารถ "Add to Home Screen" เพื่อติดตั้งเป็น App
   - บน Desktop Chrome: คลิก install icon ใน address bar

### 📱 การติดตั้งเป็น PWA

#### บน Android/iOS:
1. เปิดเว็บไซต์ใน Chrome/Safari
2. เมนู → "Add to Home Screen" หรือ "Install App"
3. แอปจะปรากฏใน Home Screen

#### บน Desktop:
1. เปิดเว็บไซต์ใน Chrome/Edge
2. คลิก install icon (⬇️) ใน address bar
3. หรือ เมนู → "Install [ชื่อแอป]"

#### ข้อกำหนดสำหรับ PWA:
- ✅ HTTPS (หรือ localhost สำหรับ development)
- ✅ Valid manifest.json
- ✅ Service Worker ที่ทำงาน
- ✅ Icons ครบตามขนาด (ดู ICONS.md)

### การใช้งาน

#### 📝 การบันทึกนัดหมาย
```
วิธีที่ 1: พิมพ์ข้อความ
"ประชุมทีม วันนี้ 14:00 ห้องประชุม"

วิธีที่ 2: ใช้เสียง
กดปุ่มไมโครโฟนแล้วพูด

วิธีที่ 3: ทีละขั้นตอน
ระบบจะถามทีละขั้นตอน
```

#### 👀 การดูนัดหมาย
- **Quick Actions**: ใช้ปุ่มด่วน (วันนี้, พรุ่งนี้, ทั้งหมด, สัปดาห์นี้)
- **พิมพ์คำสั่ง**: "แสดงนัดหมายวันนี้", "ดูนัดหมายทั้งหมด"

## 🎨 การออกแบบ

### Glassmorphism UI
```css
background: rgba(255, 255, 255, 0.95);
backdrop-filter: blur(20px);
border: 1px solid rgba(255, 255, 255, 0.2);
box-shadow: 0 32px 64px rgba(0, 0, 0, 0.15);
```

### สีหลักที่ใช้
- **Primary**: `#6366f1` (Indigo)
- **Secondary**: `#8b5cf6` (Purple)
- **Accent**: `#ec4899` (Pink)
- **Background**: Gradient combination

### Font Awesome Icons
- 📅 `fa-calendar-check` - Header icon
- 🔊 `fa-microphone` - Voice input
- ✈️ `fa-paper-plane` - Send message
- 📍 `fa-map-marker-alt` - Location
- ⏰ `fa-clock` - Time

## 📂 โครงสร้างไฟล์

```
appointment-chat/
├── index.html              # หน้าหลักของแอป
├── manifest.json           # PWA Manifest
├── sw.js                  # Service Worker สำหรับ offline support
├── package.json           # Node.js dependencies
├── README.md              # เอกสารนี้
├── ICONS.md               # คู่มือการสร้าง icons
├── icon-generator.html    # Web-based icon generator
├── generate-assets.js     # Node.js icon generator
├── generate_icons.py      # Python icon generator
├── generate-icons.bat     # Windows batch script
├── generate-icons.sh      # macOS/Linux shell script
└── .github/
    └── copilot-instructions.md
```

## 🎨 การสร้างไอคอนและ Screenshots

### 🚀 วิธีที่ 1: ใช้ Script อัตโนมัติ (แนะนำ)

#### Windows:
```bash
# เรียกใช้ batch script
.\generate-icons.bat
```

#### macOS/Linux:
```bash
# ทำให้ไฟล์สามารถรันได้
chmod +x generate-icons.sh

# รัน script
./generate-icons.sh
```

### 🌐 วิธีที่ 2: ใช้ Web Generator
1. เปิดไฟล์ `icon-generator.html` ใน web browser
2. คลิก "📦 ดาวน์โหลดไอคอนทั้งหมด"
3. คลิก "📦 ดาวน์โหลด Screenshots ทั้งหมด"
4. ไฟล์จะถูกดาวน์โหลดอัตโนมัติ

### 🐍 วิธีที่ 3: ใช้ Python (เฉพาะ Icons)
```bash
# ติดตั้ง dependencies
pip install Pillow

# รัน Python script
python3 generate_icons.py
```

### 📦 วิธีที่ 4: ใช้ Node.js (ครบ Icons + Screenshots)
```bash
# ติดตั้ง dependencies
npm install canvas

# รัน Node.js script
node generate-assets.js
```

## 🔧 Service Worker Features

### การทำงานแบบ Offline-First
```javascript
// Network First with Cache Fallback Strategy
- พยายามเรียกจาก network ก่อน
- หาก network fail ให้ fallback ไป cache
- Cache static files (CSS, JS, Fonts) automatically
- Dynamic caching สำหรับ content ใหม่
```

### Background Sync
```javascript
// ระบบ sync ข้อมูลเมื่อกลับมา online
self.addEventListener('sync', (event) => {
  if (event.tag === 'appointment-sync') {
    event.waitUntil(syncAppointments());
  }
});
```

### Push Notifications
```javascript
// รองรับการแจ้งเตือนแบบ push
self.addEventListener('push', (event) => {
  // แสดง notification เมื่อได้รับ push
});
```

## 🔧 การทำงานภายใน

### Database Schema (IndexedDB)
```javascript
// Appointments Store
{
  id: (auto-increment),
  userId: "user_timestamp",
  title: "ชื่องาน",
  date: "YYYY-MM-DD",
  time: "HH:MM",
  location: "สถานที่",
  createdAt: "ISO timestamp",
  synced: boolean
}

// Pending Sync Store
{
  id: (auto-increment),
  ...appointmentData
}
```

### การทำงานแบบ Offline-First
1. **บันทึกข้อมูล**: เก็บใน IndexedDB ก่อนเสมอ
2. **Sync ออนไลน์**: เมื่อมีอินเทอร์เน็ตจึงส่งไปเซิร์ฟเวอร์
3. **Pending Queue**: เก็บรายการที่ยังไม่ได้ sync
4. **Status Indicator**: แสดงสถานะ Online/Offline

## 🛠️ การพัฒนาเพิ่มเติม

### การเพิ่มฟีเจอร์ใหม่
```javascript
// เพิ่มฟีเจอร์ในฟังก์ชัน processMessage()
if (lowerMsg.includes('คำสั่งใหม่')) {
    await newFeature(message);
}
```

### การปรับแต่ง UI
```css
/* ปรับสีธีม */
:root {
    --primary-color: #your-color;
    --secondary-color: #your-color;
}
```

### การเชื่อมต่อ Backend
```javascript
// ปรับใน syncAppointmentToServer()
const response = await fetch('your-api-endpoint', {
    method: 'POST',
    body: JSON.stringify(appointment)
});
```

## 🌟 ฟีเจอร์ที่สามารถเพิ่มได้ในอนาคต

- [ ] **การแก้ไข/ลบนัดหมาย**: แก้ไขและลบนัดหมายที่มีอยู่
- [ ] **การแชร์นัดหมาย**: แชร์นัดหมายให้ผู้อื่น
- [ ] **Calendar View**: แสดงปฏิทินแบบมองเห็นภาพ
- [ ] **Categories**: จัดหมวดหมู่นัดหมาย
- [ ] **Recurring Events**: นัดหมายที่ซ้ำรอบ
- [ ] **Team Collaboration**: การทำงานร่วมกันเป็นทีม
- [ ] **API Integration**: เชื่อมต่อกับ Google Calendar, Outlook

## 🐛 การแก้ไขปัญหา

### ปัญหาที่พบบ่อย

**1. Speech Recognition ไม่ทำงาน**
```javascript
// ตรวจสอบการรองรับ
if (!('webkitSpeechRecognition' in window)) {
    console.log('Browser ไม่รองรับ Speech Recognition');
}
```

**2. Notification ไม่แสดง**
```javascript
// ขออนุญาต Notification
if (Notification.permission === 'default') {
    Notification.requestPermission();
}
```

**3. PWA ติดตั้งไม่ได้**
- ตรวจสอบ `manifest.json`
- ต้องใช้ HTTPS (ยกเว้น localhost)
- ต้องมี Service Worker

## 📄 License

MIT License - สามารถใช้งานและปรับแต่งได้อย่างอิสระ

## 👨‍💻 ผู้พัฒนา

พัฒนาด้วย ❤️ โดย Goragod Wiriya

---
*อัปเดตล่าสุด: 30 กันยายน 2568*