<?php
header('Content-Type: application/json');

// Get PHP upload limits
$uploadMaxFilesize = ini_get('upload_max_filesize');
$postMaxSize = ini_get('post_max_size');
$maxFileUploads = ini_get('max_file_uploads');

// Convert to bytes
/**
 * @param $size
 */
function parseSize($size)
{
    $unit = preg_replace('/[^bkmgtpezy]/i', '', $size); // Remove everything that is not [bkmgtpezy]
    $size = preg_replace('/[^0-9\.]/', '', $size); // Remove everything that is not a number
    if ($unit) {
        return round($size * pow(1024, stripos('bkmgtpezy', $unit[0])));
    } else {
        return round($size);
    }
}

$limits = [
    'upload_max_filesize' => parseSize($uploadMaxFilesize),
    'post_max_size' => parseSize($postMaxSize),
    'max_file_uploads' => (int) $maxFileUploads,
    'upload_max_filesize_formatted' => $uploadMaxFilesize,
    'post_max_size_formatted' => $postMaxSize
];

echo json_encode(['success' => true, 'limits' => $limits]);
